/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import org.apache.log4j.Logger;
import org.docx4j.convert.out.AbstractConversionSettings;
import org.docx4j.convert.out.Output;
import org.docx4j.convert.out.html.TableWriter;
import org.docx4j.fonts.Mapper;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.AdHocProperty;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.model.properties.table.BorderBottom;
import org.docx4j.model.properties.table.BorderLeft;
import org.docx4j.model.properties.table.BorderRight;
import org.docx4j.model.properties.table.BorderTop;
import org.docx4j.model.styles.Node;
import org.docx4j.model.styles.StyleTree;
import org.docx4j.model.styles.Tree;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHtmlExporter
implements Output {
    protected static Logger log = Logger.getLogger(AbstractHtmlExporter.class);
    WordprocessingMLPackage wmlPackage;
    HtmlSettings htmlSettings;

    @Override
    public abstract void output(Result var1) throws Docx4JException;

    public void setWmlPackage(WordprocessingMLPackage wmlPackage) {
        this.wmlPackage = wmlPackage;
    }

    public void setHtmlSettings(HtmlSettings htmlSettings) {
        this.htmlSettings = htmlSettings;
    }

    @Deprecated
    public abstract void html(WordprocessingMLPackage var1, Result var2, String var3) throws Exception;

    @Deprecated
    public abstract void html(WordprocessingMLPackage var1, Result var2, boolean var3, String var4) throws Exception;

    public abstract void html(WordprocessingMLPackage var1, Result var2, HtmlSettings var3) throws Exception;

    public static String resolveHref(WordprocessingMLPackage wmlPackage, String id) {
        Relationship rel = wmlPackage.getMainDocumentPart().getRelationshipsPart().getRelationshipByID(id);
        if (rel != null) {
            return rel.getTarget();
        }
        log.error((Object)("Couldn't resolve hyperlink for rel " + id));
        return "";
    }

    public static String getNumberXmlNode(WordprocessingMLPackage wmlPackage, NodeIterator pPrNodeIt, String pStyleVal, String numId, String levelId) {
        log.debug((Object)("numbering, using style '" + pStyleVal + "'; numId=" + numId + "; ilvl " + levelId));
        try {
            Emulator.ResultTriple triple = Emulator.getNumber(wmlPackage, pStyleVal, numId, levelId);
            if (triple == null) {
                log.debug((Object)"computed number ResultTriple was null");
                return null;
            }
            String styleVal = "";
            if (triple.getBullet() != null) {
                return "\u2022  ";
            }
            if (triple.getNumString() == null) {
                log.error((Object)"computed NumString was null!");
                return "?  ";
            }
            return triple.getNumString() + " ";
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return "?  ";
        }
    }

    public static String getCssForStyles(WordprocessingMLPackage wmlPackage) {
        StringBuffer result = new StringBuffer();
        StyleTree styleTree = null;
        try {
            styleTree = wmlPackage.getMainDocumentPart().getStyleTree();
        }
        catch (Exception e) {
            log.error((Object)"Couldn't getStyleTree", (Throwable)e);
            return result.toString();
        }
        result.append("\n /* TABLE STYLES */ \n");
        Tree<StyleTree.AugmentedStyle> tableTree = styleTree.getTableStylesTree();
        for (Node<StyleTree.AugmentedStyle> n : tableTree.toList()) {
            Style s = n.getData().getStyle();
            result.append("." + s.getStyleId() + " {display:table;");
            if (s.getTblPr() != null) {
                log.debug((Object)"Applying tblPr..");
                AbstractHtmlExporter.createCss(s.getTblPr(), result);
            }
            if (s.getTblStylePr() != null) {
                log.debug((Object)"Applying tblStylePr.. TODO!");
                AbstractHtmlExporter.createCss(s.getTblStylePr(), result);
            }
            if (s.getTrPr() != null) {
                log.debug((Object)"Applying trPr.. TODO!");
                AbstractHtmlExporter.createCss(s.getTrPr(), result);
            }
            if (s.getTcPr() != null) {
                log.debug((Object)"Applying tcPr.. ");
                AbstractHtmlExporter.createCss(s.getTcPr(), result);
            }
            if (s.getPPr() == null) {
                log.debug((Object)("null pPr for style " + s.getStyleId()));
            } else {
                AbstractHtmlExporter.createCss(wmlPackage, s.getPPr(), result, false);
            }
            if (s.getRPr() == null) {
                log.debug((Object)("null rPr for style " + s.getStyleId()));
            } else {
                AbstractHtmlExporter.createCss(wmlPackage, s.getRPr(), result);
            }
            result.append("}\n");
        }
        result.append("\n /* PARAGRAPH STYLES */ \n");
        Tree<StyleTree.AugmentedStyle> pTree = styleTree.getParagraphStylesTree();
        for (Node<StyleTree.AugmentedStyle> n : pTree.toList()) {
            Style s = n.getData().getStyle();
            result.append("." + s.getStyleId() + " {display:block;");
            if (s.getPPr() == null) {
                log.debug((Object)("null pPr for style " + s.getStyleId()));
            } else {
                AbstractHtmlExporter.createCss(wmlPackage, s.getPPr(), result, false);
            }
            if (s.getRPr() == null) {
                log.debug((Object)("null rPr for style " + s.getStyleId()));
            } else {
                AbstractHtmlExporter.createCss(wmlPackage, s.getRPr(), result);
            }
            result.append("}\n");
        }
        result.append("\n /* CHARACTER STYLES */ ");
        Tree<StyleTree.AugmentedStyle> cTree = styleTree.getCharacterStylesTree();
        for (Node<StyleTree.AugmentedStyle> n : cTree.toList()) {
            Style s = n.getData().getStyle();
            result.append("." + s.getStyleId() + " {display:inline;");
            if (s.getRPr() == null) {
                log.warn((Object)("! null rPr for character style " + s.getStyleId()));
            } else {
                AbstractHtmlExporter.createCss(wmlPackage, s.getRPr(), result);
            }
            result.append("}\n");
        }
        if (log.isDebugEnabled()) {
            return result.toString();
        }
        String debug = result.toString();
        return debug;
    }

    public static String getCssForTableCells(WordprocessingMLPackage wmlPackage, NodeIterator tables) {
        StringBuffer result = new StringBuffer();
        Element n = (Element)tables.nextNode();
        if (n == null) {
            return "";
        }
        int idx = 0;
        do {
            if (n.getNodeName().equals("w:tbl")) {
                try {
                    Unmarshaller u = Context.jc.createUnmarshaller();
                    u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                    Object jaxb = u.unmarshal((org.w3c.dom.Node)n);
                    Tbl tbl = (Tbl)jaxb;
                    result.append(AbstractHtmlExporter.getCssForTableCells(wmlPackage, tbl, idx));
                }
                catch (JAXBException e1) {
                    log.error((Object)"JAXB error", (Throwable)e1);
                }
                catch (ClassCastException e) {
                    log.error((Object)"Couldn't cast to Tbl!");
                }
            } else {
                log.warn((Object)("Expected table but encountered: " + n.getNodeName()));
            }
            ++idx;
        } while ((n = (Element)tables.nextNode()) != null);
        return result.toString();
    }

    public static String getCssForTableCells(WordprocessingMLPackage wmlPackage, Tbl tbl, int idx) {
        PropertyResolver pr;
        StringBuffer result = new StringBuffer();
        try {
            pr = new PropertyResolver(wmlPackage);
        }
        catch (Docx4JException e) {
            log.error((Object)"docx4j error", (Throwable)e);
            return e.getMessage();
        }
        Style s = pr.getEffectiveTableStyle(tbl.getTblPr());
        result.append("#" + TableWriter.getId(idx) + " td { ");
        ArrayList<Property> properties = new ArrayList<Property>();
        if (s.getTblPr() != null && s.getTblPr().getTblBorders() != null) {
            TblBorders tblBorders = s.getTblPr().getTblBorders();
            if (tblBorders.getInsideH() != null) {
                if (tblBorders.getInsideH().getVal() == STBorder.NONE || tblBorders.getInsideH().getVal() == STBorder.NIL || tblBorders.getInsideH().getSz() == BigInteger.ZERO) {
                    properties.add(new AdHocProperty("border-top-style", "none", null, null));
                    properties.add(new AdHocProperty("border-top-width", "0mm", null, null));
                    properties.add(new AdHocProperty("border-bottom-style", "none", null, null));
                    properties.add(new AdHocProperty("border-bottom-width", "0mm", null, null));
                } else {
                    properties.add(new BorderTop(tblBorders.getTop()));
                    properties.add(new BorderBottom(tblBorders.getBottom()));
                }
            }
            if (tblBorders.getInsideV() != null) {
                if (tblBorders.getInsideV().getVal() == STBorder.NONE || tblBorders.getInsideV().getVal() == STBorder.NIL || tblBorders.getInsideV().getSz() == BigInteger.ZERO) {
                    properties.add(new AdHocProperty("border-left-style", "none", null, null));
                    properties.add(new AdHocProperty("border-left-width", "0mm", null, null));
                    properties.add(new AdHocProperty("border-right-style", "none", null, null));
                    properties.add(new AdHocProperty("border-right-width", "0mm", null, null));
                } else {
                    properties.add(new BorderRight(tblBorders.getRight()));
                    properties.add(new BorderLeft(tblBorders.getLeft()));
                }
            }
        }
        if (s.getTcPr() != null) {
            PropertyFactory.createProperties(properties, s.getTcPr());
        }
        properties.add(new AdHocProperty("height", "5mm", null, null));
        for (Property p : properties) {
            if (p == null) continue;
            result.append(p.getCssProperty());
        }
        result.append("}\n");
        return result.toString();
    }

    protected static void createCss(CTTblPrBase tblPr, StringBuffer result) {
        if (tblPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tblPr);
        for (Property p : properties) {
            result.append(p.getCssProperty());
        }
    }

    protected static void createCss(List<CTTblStylePr> tblStylePrList, StringBuffer result) {
        if (tblStylePrList == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tblStylePrList);
        for (Property p : properties) {
            result.append(p.getCssProperty());
        }
    }

    protected static void createCss(TrPr trPr, StringBuffer result) {
        if (trPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(trPr);
        for (Property p : properties) {
            result.append(p.getCssProperty());
        }
    }

    protected static void createCss(TcPr tcPr, StringBuffer result) {
        if (tcPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(tcPr);
        for (Property p : properties) {
            result.append(p.getCssProperty());
        }
    }

    public static void createCss(OpcPackage wmlPackage, PPr pPr, StringBuffer result, boolean ignoreBorders) {
        if (pPr == null) {
            return;
        }
        List<Property> properties = PropertyFactory.createProperties(wmlPackage, pPr);
        for (Property p : properties) {
            if (ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom)) continue;
            if (p instanceof PShading) {
                String fill = ((CTShd)p.getObject()).getFill();
                result.append("border-color: #" + fill + "; border-style:solid; border-width:1px;");
            }
            result.append(p.getCssProperty());
        }
    }

    public static void createCss(OpcPackage wmlPackage, RPr rPr, StringBuffer result) {
        List<Property> properties = PropertyFactory.createProperties(wmlPackage, rPr);
        for (Property p : properties) {
            result.append(p.getCssProperty());
        }
    }

    public static class HtmlSettings
    extends AbstractConversionSettings {
        public static final String IMAGE_TARGET_URI = "imageTargetUri";
        public static final String CONDITIONAL_COMMENTS = "conditionalComments";
        public static final String FONT_FAMILY_STACK = "fontFamilyStack";
        public static final String USER_CSS = "userCSS";
        public static final String USER_SCRIPT = "userScript";
        public static final String USER_BODY_TOP = "userBodyTop";
        public static final String USER_BODY_TAIL = "userBodyTail";

        public HtmlSettings() {
            this.settings.put(CONDITIONAL_COMMENTS, Boolean.FALSE);
            this.settings.put(FONT_FAMILY_STACK, Boolean.FALSE);
            this.settings.put(USER_CSS, "");
            this.settings.put(USER_SCRIPT, "");
            this.settings.put(USER_BODY_TOP, "<!-- userBodyTop goes here -->");
            this.settings.put(USER_BODY_TAIL, "<!-- userBodyTail goes here -->");
        }

        public void setConditionalComments(Boolean conditionalComments) {
            this.settings.put(CONDITIONAL_COMMENTS, conditionalComments);
        }

        public void setFontFamilyStack(boolean val) {
            this.settings.put(FONT_FAMILY_STACK, new Boolean(val));
        }

        public void setFontMapper(Mapper fontMapper) {
            this.settings.put("fontMapper", fontMapper);
        }

        public Mapper getFontMapper() {
            return (Mapper)this.settings.get("fontMapper");
        }

        public void setUserCSS(String val) {
            this.settings.put(USER_CSS, val);
        }

        public void setUserScript(String val) {
            this.settings.put(USER_SCRIPT, val);
        }

        public void setUserBodyTop(String val) {
            this.settings.put(USER_BODY_TOP, val);
        }

        public void setUserBodyTail(String val) {
            this.settings.put(USER_BODY_TAIL, val);
        }

        public void setImageTargetUri(String imageTargetUri) {
            this.settings.put(IMAGE_TARGET_URI, imageTargetUri);
        }

        public String getImageTargetUri() {
            return (String)this.settings.get(IMAGE_TARGET_URI);
        }
    }
}

