/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.html;

import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.ModelConverter;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.model.Model;
import org.docx4j.model.SymbolModel;
import org.docx4j.model.TransformState;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolWriter
extends ModelConverter {
    private static final Logger log = Logger.getLogger(SymbolWriter.class);

    public Node toNode(Model symbolModel, TransformState state) throws TransformerException {
        SymbolModel sm = (SymbolModel)symbolModel;
        String value = sm.getSym().getChar();
        if (value.startsWith("F0") || value.startsWith("f0")) {
            value = value.substring(2);
        }
        Document doc = XmlUtils.neww3cDomDocument();
        Text theChar = doc.createTextNode(new String(SymbolWriter.hexStringToByteArray(value)));
        DocumentFragment docfrag = doc.createDocumentFragment();
        String fontName = sm.getSym().getFont();
        PhysicalFont pf = this.wordMLPackage.getFontMapper().getFontMappings().get(fontName);
        if (pf == null) {
            log.warn((Object)("No physical font present for:" + fontName));
            docfrag.appendChild(theChar);
        } else {
            Element span = doc.createElement("span");
            docfrag.appendChild(span);
            span.setAttribute("style", "font-family:" + pf.getName());
            span.appendChild(theChar);
        }
        return docfrag;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

