/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.pdf;

import java.io.File;
import java.io.FileOutputStream;
import java.text.NumberFormat;
import javax.xml.bind.JAXBContext;
import org.docx4j.convert.out.pdf.PdfConversion;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

public class PdfMultipleThreads {
    static final int TOTAL = 4;
    static final int REPS = 5;
    static final boolean LONGER_DOCX = false;
    static final int NUM_PAGES_SHORTER = 5;
    static final int NUM_PAGES_LONGER = 27;
    public static boolean abort = false;
    static String inputfilepath;
    static Mapper fontMapper;

    public static void main(String[] args) throws Exception {
        inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/sample-docx.xml";
        Thread[] t = new Thread[5];
        long contextStartTime = System.currentTimeMillis();
        JAXBContext blgh = Context.jc;
        long contextStartupTime = System.currentTimeMillis() - contextStartTime;
        System.out.println(contextStartupTime + " ms to initialise JAXB context");
        PhysicalFont font = PhysicalFonts.getPhysicalFonts().get("Comic Sans MS");
        fontMapper.getFontMappings().put("Calibri", font);
        for (int r = 1; r <= 5; ++r) {
            long startTime = System.currentTimeMillis();
            for (int i = 1; i <= 4; ++i) {
                t[i] = new Thread(new CreatePdf());
                t[i].setName("fo" + i);
                t[i].start();
            }
            boolean alive = true;
            while (alive && !abort) {
                int i;
                alive = false;
                boolean anyDead = false;
                for (i = 1; i <= 4; ++i) {
                    if (t[i].isAlive()) continue;
                    anyDead = true;
                    break;
                }
                for (i = 1; i <= 4; ++i) {
                    if (t[i].isAlive()) {
                        alive = true;
                        if (abort) {
                            System.out.println(i + " is alive; trying to interrupt");
                            t[i].stop();
                            continue;
                        }
                        if (!anyDead) continue;
                        System.out.println(i + " is alive");
                        continue;
                    }
                    System.out.println(i + " is finished");
                }
                if (alive) {
                    Thread.sleep(500L);
                }
                if (!abort) continue;
                System.out.println("ABORTING: iteration " + r);
                break;
            }
            if (abort) break;
            long timeElapsed = System.currentTimeMillis() - startTime;
            double elapsedSec = (double)Math.round(10L * timeElapsed / 1000L) / 10.0;
            double sec = (double)Math.round(100L * timeElapsed / 4000L) / 100.0;
            System.out.println("Iteration " + r + " of  " + 5 + " took " + elapsedSec + "sec");
            System.out.println("Average " + sec + "sec per thread");
            double ratebase = 4.0 / elapsedSec;
            System.out.println(ratebase * 5.0 + " pages/sec ");
            System.out.println("Also of interest: " + contextStartupTime + " ms to initialise JAXB context (not counted in above times)");
            System.out.println(PdfMultipleThreads.reportMemory());
            System.out.println("gc..");
            System.gc();
            System.out.println(PdfMultipleThreads.reportMemory());
            System.out.println("gc..");
            System.gc();
            System.out.println(PdfMultipleThreads.reportMemory());
        }
        if (abort) {
            System.out.println("## ABORTED.  See logs");
        } else {
            System.out.println("All done!");
        }
    }

    public static String reportMemory() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("allocated memory: " + format.format(allocatedMemory / 0x100000L) + "M\n");
        sb.append("--------------\n");
        sb.append("[ Xmx: " + format.format(maxMemory / 0x100000L) + "M ]\n");
        return sb.toString();
    }

    static {
        fontMapper = new IdentityPlusMapper();
    }

    private static class CreatePdf
    implements Runnable {
        private CreatePdf() {
        }

        public void run() {
            try {
                WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
                wordMLPackage.setFontMapper(fontMapper);
                Conversion c = new Conversion(wordMLPackage);
                FileOutputStream os = new FileOutputStream(inputfilepath + Thread.currentThread().getName() + ".pdf");
                ((PdfConversion)c).output(os, new PdfSettings());
                System.out.println("Saved " + inputfilepath + Thread.currentThread().getName() + ".pdf");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                abort = true;
                e.printStackTrace();
            }
        }
    }
}

