/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.pdf.viaXSLFO;

import java.util.List;
import org.apache.log4j.Logger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.DocumentModel;
import org.docx4j.model.structure.HeaderFooterPolicy;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.plutext.jaxb.xslfo.ConditionalPageMasterReference;
import org.plutext.jaxb.xslfo.LayoutMasterSet;
import org.plutext.jaxb.xslfo.ObjectFactory;
import org.plutext.jaxb.xslfo.OddOrEvenType;
import org.plutext.jaxb.xslfo.PagePositionType;
import org.plutext.jaxb.xslfo.PageSequenceMaster;
import org.plutext.jaxb.xslfo.RegionAfter;
import org.plutext.jaxb.xslfo.RegionBefore;
import org.plutext.jaxb.xslfo.RegionBody;
import org.plutext.jaxb.xslfo.RepeatablePageMasterAlternatives;
import org.plutext.jaxb.xslfo.SimplePageMaster;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public class LayoutMasterSetBuilder {
    protected static Logger log = Logger.getLogger(LayoutMasterSetBuilder.class);
    private static ObjectFactory factory;
    private static final int HEADER_PADDING_TWIP = 360;
    private static final int FOOTER_PADDING_TWIP = 360;
    private static final int MIN_PAGE_MARGIN = 360;

    public static DocumentFragment getLayoutMasterSetFragment(WordprocessingMLPackage wordMLPackage) {
        LayoutMasterSet lms = LayoutMasterSetBuilder.getFoLayoutMasterSet(wordMLPackage);
        Document document = XmlUtils.marshaltoW3CDomDocument(lms, Context.getXslFoContext());
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    private static LayoutMasterSet getFoLayoutMasterSet(WordprocessingMLPackage wordMLPackage) {
        factory = new ObjectFactory();
        LayoutMasterSet lms = factory.createLayoutMasterSet();
        DocumentModel documentModel = wordMLPackage.getDocumentModel();
        List<SectionWrapper> sections = documentModel.getSections();
        int i = 1;
        for (SectionWrapper sw : sections) {
            HeaderFooterPolicy hf = sw.getHeaderFooterPolicy();
            String sectionName = "s" + i;
            if (hf.getFirstHeader() != null || hf.getFirstFooter() != null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-firstpage", sw.getPageDimensions(), "firstpage", hf.getFirstHeader() != null, hf.getFirstFooter() != null));
            }
            if (hf.getDefaultHeader() != null || hf.getDefaultFooter() != null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-default", sw.getPageDimensions(), "default", hf.getDefaultHeader() != null, hf.getDefaultFooter() != null));
            } else if (hf.getEvenHeader() != null || hf.getOddHeader() != null || hf.getEvenFooter() != null || hf.getOddFooter() != null) {
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-evenpage", sw.getPageDimensions(), "evenpage", hf.getEvenHeader() != null, hf.getEvenFooter() != null));
                lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-oddpage", sw.getPageDimensions(), "default", hf.getOddHeader() != null, hf.getOddFooter() != null));
            }
            lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createSimplePageMaster(sectionName + "-simple", sw.getPageDimensions(), "simple", true, true));
            lms.getSimplePageMasterOrPageSequenceMaster().add(LayoutMasterSetBuilder.createPageSequenceMaster(hf, sectionName));
            ++i;
        }
        return lms;
    }

    private static PageSequenceMaster createPageSequenceMaster(HeaderFooterPolicy hf, String sectionName) {
        PageSequenceMaster psm = factory.createPageSequenceMaster();
        psm.setMasterName(sectionName);
        RepeatablePageMasterAlternatives rpma = factory.createRepeatablePageMasterAlternatives();
        psm.getSinglePageMasterReferenceOrRepeatablePageMasterReferenceOrRepeatablePageMasterAlternatives().add(rpma);
        if (hf.getFirstHeader() != null || hf.getFirstFooter() != null) {
            ConditionalPageMasterReference cpmr1 = factory.createConditionalPageMasterReference();
            cpmr1.setMasterReference(sectionName + "-firstpage");
            cpmr1.setPagePosition(PagePositionType.FIRST);
            rpma.getConditionalPageMasterReference().add(cpmr1);
        }
        if (hf.getDefaultHeader() != null || hf.getDefaultFooter() != null) {
            ConditionalPageMasterReference cpmr4 = factory.createConditionalPageMasterReference();
            cpmr4.setMasterReference(sectionName + "-default");
            rpma.getConditionalPageMasterReference().add(cpmr4);
        } else if (hf.getEvenHeader() != null || hf.getEvenFooter() != null) {
            ConditionalPageMasterReference cpmr2 = factory.createConditionalPageMasterReference();
            cpmr2.setMasterReference(sectionName + "-evenpage");
            cpmr2.setOddOrEven(OddOrEvenType.EVEN);
            rpma.getConditionalPageMasterReference().add(cpmr2);
            ConditionalPageMasterReference cpmr3 = factory.createConditionalPageMasterReference();
            cpmr3.setMasterReference(sectionName + "-oddpage");
            cpmr3.setOddOrEven(OddOrEvenType.ODD);
            rpma.getConditionalPageMasterReference().add(cpmr3);
        }
        ConditionalPageMasterReference cpmr5 = factory.createConditionalPageMasterReference();
        cpmr5.setMasterReference(sectionName + "-simple");
        rpma.getConditionalPageMasterReference().add(cpmr5);
        return psm;
    }

    private static SimplePageMaster createSimplePageMaster(String masterName, PageDimensions page, String appendRegionName, boolean needBefore, boolean needAfter) {
        SimplePageMaster spm = factory.createSimplePageMaster();
        spm.setMasterName(masterName);
        spm.setPageHeight(UnitsOfMeasurement.twipToBest(page.getPgSz().getH().intValue()));
        spm.setPageWidth(UnitsOfMeasurement.twipToBest(page.getPgSz().getW().intValue()));
        spm.setMarginLeft(UnitsOfMeasurement.twipToBest(page.getPgMar().getLeft().intValue()));
        spm.setMarginRight(UnitsOfMeasurement.twipToBest(page.getPgMar().getRight().intValue()));
        RegionBody rb = factory.createRegionBody();
        rb.setMarginLeft("0mm");
        rb.setMarginRight("0mm");
        spm.setRegionBody(rb);
        if (needBefore) {
            RegionBefore rBefore = factory.createRegionBefore();
            rBefore.setRegionName("xsl-region-before-" + appendRegionName);
            spm.setRegionBefore(rBefore);
            int marginTopTwips = page.getPgMar().getTop().intValue() - (360 + page.getHeaderExtent() + page.getHeaderMargin());
            if (marginTopTwips < 360) {
                marginTopTwips = 360;
            }
            spm.setMarginTop(UnitsOfMeasurement.twipToBest(marginTopTwips));
            rBefore.setExtent(UnitsOfMeasurement.twipToBest(page.getHeaderExtent()));
            rb.setMarginTop(UnitsOfMeasurement.twipToBest(page.getHeaderExtent() + 360));
        } else {
            spm.setMarginTop(UnitsOfMeasurement.twipToBest(page.getPgMar().getTop().intValue()));
        }
        if (needAfter) {
            RegionAfter rAfter = factory.createRegionAfter();
            rAfter.setRegionName("xsl-region-after-" + appendRegionName);
            spm.setRegionAfter(rAfter);
            int marginBottomTwips = page.getPgMar().getBottom().intValue() - (360 + page.getFooterExtent() + page.getFooterMargin());
            if (marginBottomTwips < 360) {
                marginBottomTwips = 360;
            }
            log.debug((Object)("marginBottomTwips: " + marginBottomTwips));
            spm.setMarginBottom(UnitsOfMeasurement.twipToBest(marginBottomTwips));
            rAfter.setExtent(UnitsOfMeasurement.twipToBest(page.getFooterExtent()));
            rb.setMarginBottom(UnitsOfMeasurement.twipToBest(page.getFooterExtent() + 360));
        } else {
            spm.setMarginBottom(UnitsOfMeasurement.twipToBest(page.getPgMar().getBottom().intValue()));
        }
        return spm;
    }
}

