/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.listnumbering;

import java.io.File;
import java.util.StringTokenizer;
import org.docx4j.XmlUtils;
import org.docx4j.model.PropertyResolver;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;
import org.junit.Assert;
import org.junit.Test;

public class IndentationTest {
    static final String EXPECT_START = "[expect]";
    static final String EXPECT_END = "[/expect]";

    @Test
    public void testIndents() throws Docx4JException {
        String inputfilepath = System.getProperty("user.dir") + "/src/test/java/org/docx4j/model/listnumbering/NumberingIndents";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath + ".docx"));
        PropertyResolver propertyResolver = wordMLPackage.getMainDocumentPart().getPropertyResolver();
        int EXPECT_START_LENGTH = EXPECT_START.length();
        int assertionCount = 0;
        for (Object o : wordMLPackage.getMainDocumentPart().getContent()) {
            PPr pPr;
            P p;
            if (!(o instanceof P) || (p = (P)o).getPPr() == null || (pPr = propertyResolver.getEffectivePPr(p.getPPr())).getInd() == null) continue;
            String actual = this.removeNamespaces(XmlUtils.marshaltoString(pPr.getInd(), true));
            Text text = (Text)XmlUtils.unwrap(((R)p.getContent().get(0)).getContent().get(0));
            String content = text.getValue();
            if (content.indexOf(EXPECT_START) < 0) continue;
            content = content.substring(content.indexOf(EXPECT_START));
            StringTokenizer st = new StringTokenizer(content, EXPECT_START);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int end = content.indexOf(EXPECT_END);
                String expectedResult = content.substring(EXPECT_START_LENGTH, end);
                Assert.assertTrue((String)("Expected " + expectedResult + " but got " + actual), (boolean)actual.contains(expectedResult));
                ++assertionCount;
            }
        }
        System.out.println("Assertions tested: " + assertionCount);
        Assert.assertTrue((String)"No assertions were tested", (assertionCount > 0 ? 1 : 0) != 0);
    }

    protected String removeNamespaces(String in) {
        StringTokenizer st = new StringTokenizer(in, " ");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contains("xmlns:")) {
                if (!token.contains(">")) continue;
                sb.append(">");
                continue;
            }
            sb.append(token + " ");
        }
        return sb.toString();
    }
}

