/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import org.docx4j.UnitsOfMeasurement;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.org.xhtmlrenderer.css.parser.FSColor;
import org.docx4j.org.xhtmlrenderer.css.parser.FSRGBColor;
import org.docx4j.org.xhtmlrenderer.css.parser.PropertyValue;
import org.docx4j.wml.Color;
import org.docx4j.wml.RPr;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class FontColor
extends AbstractRunProperty {
    public static final String CSS_NAME = "color";
    public static final String FO_NAME = "color";

    public String getCssName() {
        return "color";
    }

    public FontColor(Color color) {
        this.setObject(color);
    }

    public FontColor(CSSValue value) {
        float fBlue;
        float fGreen;
        float fRed;
        short ignored = 1;
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        try {
            fRed = cssPrimitiveValue.getRGBColorValue().getRed().getFloatValue(ignored);
            fGreen = cssPrimitiveValue.getRGBColorValue().getGreen().getFloatValue(ignored);
            fBlue = cssPrimitiveValue.getRGBColorValue().getBlue().getFloatValue(ignored);
        }
        catch (UnsupportedOperationException e) {
            if (!(cssPrimitiveValue instanceof PropertyValue)) {
                throw e;
            }
            FSColor fsColor = ((PropertyValue)cssPrimitiveValue).getFSColor();
            if (!(fsColor instanceof FSRGBColor)) {
                throw e;
            }
            fRed = ((FSRGBColor)fsColor).getRed();
            fGreen = ((FSRGBColor)fsColor).getGreen();
            fBlue = ((FSRGBColor)fsColor).getBlue();
        }
        Color color = Context.getWmlObjectFactory().createColor();
        color.setVal(UnitsOfMeasurement.rgbTripleToHex(fRed, fGreen, fBlue));
        this.setObject(color);
    }

    public String getCssProperty() {
        if (((Color)this.getObject()).getVal() != null) {
            return FontColor.composeCss("color", "#" + ((Color)this.getObject()).getVal());
        }
        return "";
    }

    public void setXslFO(Element foElement) {
        if (((Color)this.getObject()).getVal() != null) {
            foElement.setAttribute("color", "#" + ((Color)this.getObject()).getVal());
        }
    }

    public void set(RPr rPr) {
        rPr.setColor((Color)this.getObject());
    }
}

