/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.log4j.Logger;
import org.docx4j.docProps.custom.ObjectFactory;
import org.docx4j.docProps.custom.Properties;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocPropsCustomPart
extends JaxbXmlPart<Properties> {
    private static Logger log = Logger.getLogger(DocPropsCustomPart.class);
    public static final String fmtidValLpwstr = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";

    public DocPropsCustomPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DocPropsCustomPart() throws InvalidFormatException {
        super(new PartName("/docProps/custom.xml"));
        this.init();
    }

    public void init() {
        this.jc = Context.jcDocPropsCustom;
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.custom-properties+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties");
    }

    @Override
    public Properties unmarshal(InputStream is) throws JAXBException {
        try {
            this.setJAXBContext(Context.jcDocPropsCustom);
            Unmarshaller u = this.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            log.info((Object)("unmarshalling " + this.getClass().getName()));
            this.jaxbElement = (Properties)u.unmarshal(is);
            log.info((Object)("\n\n" + this.getClass().getName() + " unmarshalled \n\n"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Properties)this.jaxbElement;
    }

    public String getProperty(String propName) {
        Properties customProps = (Properties)this.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            log.info((Object)prop.getName());
            if (!prop.getName().equals(propName)) continue;
            log.info((Object)("GOT IT! returning " + prop.getLpwstr()));
            return prop.getLpwstr();
        }
        return null;
    }

    public void setProperty(String propName, String propValue) {
        Properties.Property newProp = null;
        Properties customProps = (Properties)this.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            if (!prop.getName().equals(propName)) continue;
            log.warn((Object)("Replacing existing property: " + propName));
            newProp = prop;
            if (newProp.getFmtid().equals(fmtidValLpwstr)) break;
            log.warn((Object)"Wrong fmtid?  This might not work...");
            break;
        }
        if (newProp == null) {
            ObjectFactory factory = new ObjectFactory();
            newProp = factory.createPropertiesProperty();
            newProp.setName(propName);
            newProp.setFmtid(fmtidValLpwstr);
            newProp.setPid(this.getNextPid());
            customProps.getProperty().add(newProp);
        }
        newProp.setLpwstr(propValue);
    }

    public int getNextPid() {
        int highestSeen = 1;
        Properties customProps = (Properties)this.getJaxbElement();
        for (Properties.Property prop : customProps.getProperty()) {
            if (prop.getPid() <= highestSeen) continue;
            highestSeen = prop.getPid();
        }
        log.debug((Object)("Returning " + highestSeen + 1));
        return highestSeen + 1;
    }
}

