/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.DrawingML;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.diagram.CTCxn;
import org.docx4j.dml.diagram.CTDataModel;
import org.docx4j.dml.diagram.CTElemPropSet;
import org.docx4j.dml.diagram.CTPt;
import org.docx4j.dml.diagram.STPtType;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDataUnflatten;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDrawingPart;
import org.docx4j.openpackaging.parts.DrawingML.JaxbDmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiagramDataPart
extends JaxbDmlPart<CTDataModel> {
    private static Logger log = Logger.getLogger(DiagramDataPart.class);
    static HashMap<String, String> map;
    static int index;

    public DiagramDataPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DiagramDataPart() throws InvalidFormatException {
        super(new PartName("/word/diagrams/data1.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData");
    }

    public static void setFriendlyIds(Object jaxbElement) {
        map = new HashMap();
        DiagramDataPart.generateIdMap(jaxbElement);
        DiagramDataPart.ReplaceIds(jaxbElement);
    }

    protected static void generateIdMap(Object jaxbElement) {
        new TraversalUtil(jaxbElement, new TraversalUtil.Callback(){

            @Override
            public List<Object> apply(Object o) {
                String to;
                String from;
                if (o instanceof CTPt) {
                    CTPt pt = (CTPt)o;
                    from = pt.getModelId();
                    if (pt.getType() != null && pt.getType().equals((Object)STPtType.PRES)) {
                        map.put(from, DiagramDataPart.generateNiceGuid(index));
                        ++index;
                        return null;
                    }
                    to = "" + index;
                    ++index;
                    map.put(from, to);
                }
                if (o instanceof CTCxn) {
                    CTCxn cxn = (CTCxn)o;
                    from = cxn.getModelId();
                    to = "" + index;
                    ++index;
                    map.put(from, to);
                }
                return null;
            }

            @Override
            public boolean shouldTraverse(Object o) {
                return true;
            }

            @Override
            public void walkJAXBElements(Object parent) {
                List<Object> children = this.getChildren(parent);
                if (children != null) {
                    for (Object o : children) {
                        o = XmlUtils.unwrap(o);
                        this.apply(o);
                        if (!this.shouldTraverse(o)) continue;
                        this.walkJAXBElements(o);
                    }
                }
            }

            @Override
            public List<Object> getChildren(Object o) {
                return TraversalUtil.getChildrenImpl(o);
            }
        });
    }

    private static String generateNiceGuid(int index) {
        if (index < 10) {
            return "{0000000" + index + "-0000-0000-0000-000000000000}";
        }
        if (index < 100) {
            return "{000000" + index + "-0000-0000-0000-000000000000}";
        }
        return "{00000" + index + "-0000-0000-0000-000000000000}";
    }

    private static String mapGet(HashMap<String, String> map, String key) {
        if (key == null) {
            System.out.println("Key not found!");
            return null;
        }
        String val = map.get(key);
        if (val == null) {
            System.out.println("No val for Key " + key);
            return key;
        }
        return val;
    }

    protected static void ReplaceIds(Object jaxbElement) {
        new TraversalUtil(jaxbElement, new TraversalUtil.Callback(){

            @Override
            public List<Object> apply(Object o) {
                if (o instanceof CTPt) {
                    CTElemPropSet pr;
                    CTPt pt = (CTPt)o;
                    pt.setModelId(DiagramDataPart.mapGet(map, pt.getModelId()));
                    if (pt.getPrSet() != null && (pr = pt.getPrSet()).getPresAssocID() != null) {
                        pr.setPresAssocID(DiagramDataPart.mapGet(map, pr.getPresAssocID()));
                    }
                    if (!pt.getCxnId().equals("0")) {
                        pt.setCxnId(DiagramDataPart.mapGet(map, pt.getCxnId()));
                    }
                }
                if (o instanceof CTCxn) {
                    CTCxn cxn = (CTCxn)o;
                    if (cxn.getModelId() != null) {
                        cxn.setModelId(DiagramDataPart.mapGet(map, cxn.getModelId()));
                    }
                    cxn.setSrcId(DiagramDataPart.mapGet(map, cxn.getSrcId()));
                    cxn.setDestId(DiagramDataPart.mapGet(map, cxn.getDestId()));
                    if (!cxn.getSibTransId().equals("0")) {
                        cxn.setSibTransId(DiagramDataPart.mapGet(map, cxn.getSibTransId()));
                    }
                    if (!cxn.getParTransId().equals("0")) {
                        cxn.setParTransId(DiagramDataPart.mapGet(map, cxn.getParTransId()));
                    }
                }
                return null;
            }

            @Override
            public boolean shouldTraverse(Object o) {
                return true;
            }

            @Override
            public void walkJAXBElements(Object parent) {
                List<Object> children = this.getChildren(parent);
                if (children != null) {
                    for (Object o : children) {
                        o = XmlUtils.unwrap(o);
                        this.apply(o);
                        if (!this.shouldTraverse(o)) continue;
                        this.walkJAXBElements(o);
                    }
                }
            }

            @Override
            public List<Object> getChildren(Object o) {
                return TraversalUtil.getChildrenImpl(o);
            }
        });
    }

    public static String addImage(DiagramDataPart ddp, String base64) {
        log.debug((Object)("Adding image: " + base64));
        BinaryPartAbstractImage imagePart = null;
        try {
            byte[] bytes = Base64.decodeBase64((byte[])base64.getBytes("UTF8"));
            imagePart = BinaryPartAbstractImage.createImagePart(ddp.getPackage(), (Part)ddp, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            log.info((Object)".. attempting to use broken image placeholder");
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)ResourceUtils.getResource("image_broken.gif"));
                imagePart = BinaryPartAbstractImage.createImagePart(ddp.getPackage(), (Part)ddp, bytes);
                log.info((Object)".. used broken image placeholder");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return "";
            }
        }
        return imagePart.getSourceRelationships().get(0).getId();
    }

    public static void debug(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(System.getProperty("user.dir") + "/SmartArt/OUT-xx.docx"));
        Relationship r = wordMLPackage.getMainDocumentPart().getRelationshipsPart().getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData");
        if (r == null) {
            System.out.println("No DDP!");
            return;
        }
        DiagramDataPart thisPart = (DiagramDataPart)wordMLPackage.getMainDocumentPart().getRelationshipsPart().getPart(r);
        DiagramDataPart.setFriendlyIds(thisPart.getJaxbElement());
        System.out.println(XmlUtils.marshaltoString(thisPart.getJaxbElement(), true, true));
        DiagramDataUnflatten diagramDataUnflatten = new DiagramDataUnflatten(thisPart);
        String exchange = XmlUtils.marshaltoString((Object)diagramDataUnflatten.convert(), true, true);
        System.out.println(exchange);
        PrintWriter out = new PrintWriter(System.getProperty("user.dir") + "/SmartArt/12hi.xml");
        out.println(exchange);
        out.flush();
        out.close();
        List<JAXBElement<CTTextBody>> textFormats = diagramDataUnflatten.getTextFormats();
        System.out.println("Template list =============== ");
        for (JAXBElement<CTTextBody> tb : textFormats) {
            System.out.println(XmlUtils.marshaltoString(tb, true, true));
        }
        System.out.println("============================= ");
        Relationship r2 = wordMLPackage.getMainDocumentPart().getRelationshipsPart().getRelationshipByType("http://schemas.microsoft.com/office/2007/relationships/diagramDrawing");
        if (r2 == null) {
            System.out.println("No DDrawingP!");
        } else {
            DiagramDrawingPart drawingPart = (DiagramDrawingPart)wordMLPackage.getMainDocumentPart().getRelationshipsPart().getPart(r2);
            drawingPart.setFriendlyIds(map);
            System.out.println(XmlUtils.marshaltoString(drawingPart.getJaxbElement(), true, true));
        }
        SaveToZipFile saver = new SaveToZipFile(wordMLPackage);
        saver.save(System.getProperty("user.dir") + "/SmartArt/OUT-clean.docx");
    }

    static {
        index = 0;
    }
}

