/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.BufferUtil;

public class BinaryPart
extends Part {
    ExternalTarget externalTarget = null;
    ByteBuffer bb;
    private String zipFileName = null;
    private String resolvedPartUri = null;
    private Reference<ByteBuffer> bbRef = null;

    public BinaryPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public BinaryPart(ExternalTarget externalTarget) {
        this.externalTarget = externalTarget;
    }

    public ExternalTarget getExternalTarget() {
        return this.externalTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryData(InputStream binaryData) {
        log.debug((Object)"reading input stream");
        try {
            this.bb = BufferUtil.readInputStream(binaryData);
            log.debug((Object)".. done");
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            try {
                log.debug((Object)"closing binary input stream");
                binaryData.close();
                log.info((Object)".. closed.");
            }
            catch (Exception nested) {
                log.error((Object)nested);
            }
        }
    }

    public void setBinaryData(byte[] bytes) {
        this.bb = ByteBuffer.wrap(bytes);
    }

    public void setBinaryData(ByteBuffer bb) {
        this.bb = bb;
    }

    public void setBinaryDataRef(String zipFileName, String resolvedPartUri) {
        this.zipFileName = zipFileName;
        this.resolvedPartUri = resolvedPartUri;
        this.bbRef = null;
        log.debug((Object)("set binary part data reference: " + this.zipFileName + "!" + this.resolvedPartUri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer getBuffer() {
        ByteBuffer res;
        block14: {
            block15: {
                res = null;
                if (this.bb == null) break block15;
                res = this.bb;
                break block14;
            }
            if (this.zipFileName != null && this.resolvedPartUri != null) {
                ByteBuffer byteBuffer = res = this.bbRef != null ? this.bbRef.get() : null;
                if (res == null) {
                    log.debug((Object)("loading binary part data: " + this.zipFileName + "!" + this.resolvedPartUri));
                    ZipFile zf = null;
                    InputStream in = null;
                    try {
                        zf = new ZipFile(this.zipFileName);
                        in = zf.getInputStream(zf.getEntry(this.resolvedPartUri));
                        res = BufferUtil.readInputStream(in);
                        this.bbRef = new SoftReference<ByteBuffer>(res);
                        IOUtils.closeQuietly((InputStream)in);
                        if (zf == null) break block14;
                    }
                    catch (IOException ex) {
                        log.error((Object)ex);
                        break block14;
                    }
                    try {
                        zf.close();
                    }
                    catch (IOException ex) {}
                    break block14;
                    finally {
                        IOUtils.closeQuietly(in);
                        if (zf != null) {
                            try {
                                zf.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
        }
        res.rewind();
        return res;
    }

    public void writeDataToOutputStream(OutputStream out) throws IOException {
        ByteBuffer buf = this.getBuffer();
        buf.clear();
        byte[] bytes = new byte[buf.capacity()];
        buf.get(bytes, 0, bytes.length);
        out.write(bytes);
    }

    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof BinaryPart)) {
            return false;
        }
        ByteBuffer thisBB = this.getBuffer();
        ByteBuffer thatBB = ((BinaryPart)other).getBuffer();
        return thisBB.equals(thatBB);
    }
}

