/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.junit.Assert;
import org.junit.Test;

public class CreateImageTest {
    private static final int LENGTH = 1965;

    @Test
    public void testFile() throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        File file = new File(System.getProperty("user.dir") + "/src/test/resources/images/greentick.png");
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(wordMLPackage, file);
        Assert.assertTrue((boolean)(imagePart instanceof ImagePngPart));
        Assert.assertTrue((((ImagePngPart)imagePart).bb.capacity() == 1965 ? 1 : 0) != 0);
    }

    @Test
    public void testByteArray() throws Exception {
        int offset;
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        File file = new File(System.getProperty("user.dir") + "/src/test/resources/images/greentick.png");
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            System.out.println("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart(wordMLPackage, bytes);
        Assert.assertTrue((boolean)(imagePart instanceof ImagePngPart));
        Assert.assertTrue((((ImagePngPart)imagePart).bb.capacity() == 1965 ? 1 : 0) != 0);
    }

    @Test
    public void testFileUrl() throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        File file = new File(System.getProperty("user.dir") + "/src/test/resources/images/greentick.png");
        URL url = file.toURI().toURL();
        System.out.println(url);
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createLinkedImagePart(wordMLPackage, url);
        Assert.assertTrue((boolean)(imagePart instanceof ImagePngPart));
    }

    @Test
    public void testHttpUrl() throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        URL url = new URL("http://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/Green_tick.svg/75px-Green_tick.svg.png");
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createLinkedImagePart(wordMLPackage, url);
        Assert.assertTrue((boolean)(imagePart instanceof ImagePngPart));
    }
}

