/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.math.BigInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.samples.AbstractSample;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

public class BookmarkAdd
extends AbstractSample {
    public static JAXBContext context = Context.jc;

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        String outputfilepath = System.getProperty("user.dir") + "/OUT_bookmarkAdd.docx";
        wordMLPackage.getMainDocumentPart().addParagraphOfText("x");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("x");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("hello world");
        P p = (P)wordMLPackage.getMainDocumentPart().getContent().get(2);
        R r = (R)p.getContent().get(0);
        String bookmarkName = "abcd";
        BookmarkAdd.bookmarkRun(p, r, bookmarkName, 123);
        wordMLPackage.getMainDocumentPart().addParagraphOfText("x");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("x");
        P.Hyperlink h = MainDocumentPart.hyperlinkToBookmark(bookmarkName, "link to bookmark");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("some text").getContent().add(h);
        System.out.println(XmlUtils.marshaltoString(p, true));
        SaveToZipFile saver = new SaveToZipFile(wordMLPackage);
        saver.save(outputfilepath);
    }

    public static void bookmarkRun(P p, R r, String name, int id) {
        int index = p.getContent().indexOf(r);
        if (index < 0) {
            System.out.println("P does not contain R!");
            return;
        }
        ObjectFactory factory = Context.getWmlObjectFactory();
        BigInteger ID = BigInteger.valueOf(id);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(ID);
        JAXBElement<CTMarkupRange> bmEnd = factory.createBodyBookmarkEnd(mr);
        p.getContent().add(index + 1, bmEnd);
        CTBookmark bm = factory.createCTBookmark();
        bm.setId(ID);
        bm.setName(name);
        JAXBElement<CTBookmark> bmStart = factory.createBodyBookmarkStart(bm);
        p.getContent().add(index, bmStart);
    }
}

