/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.docx4j.XmlUtils;
import org.docx4j.convert.in.xhtml.XHTMLImporter;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;

public class ConvertInXHTMLFile {
    public static void main(String[] args) throws Exception {
        String stringFromFile;
        String inputfilepath = System.getProperty("user.dir") + "/tmp/2.xhtml";
        String unescaped = stringFromFile = FileUtils.readFileToString((File)new File(inputfilepath), (String)"UTF-8");
        if (stringFromFile.contains("&lt;/")) {
            unescaped = StringEscapeUtils.unescapeHtml((String)stringFromFile);
        }
        System.out.println("Unescaped: " + unescaped);
        XHTMLImporter.setHyperlinkStyle("Hyperlink");
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        NumberingDefinitionsPart ndp = new NumberingDefinitionsPart();
        wordMLPackage.getMainDocumentPart().addTargetPart(ndp);
        ndp.unmarshalDefaultNumbering();
        wordMLPackage.getMainDocumentPart().getContent().addAll(XHTMLImporter.convert(unescaped, null, wordMLPackage));
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/html_output.docx"));
    }
}

