/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.samples.AbstractSample;

public class MergeDocx
extends AbstractSample {
    static final String BASE_DIR = System.getProperty("user.dir") + "/sample-docs/word/";
    static final String[] sourceDocxNames = new String[]{"Table.docx", "Images.docx"};
    static boolean save = true;
    static String outputfilepath = System.getProperty("user.dir") + "OUT_MergeDocx.docx";

    public static void main(String[] args) throws Docx4JException {
        ArrayList<WordprocessingMLPackage> wmlPkgList = new ArrayList<WordprocessingMLPackage>();
        for (int i = 0; i < sourceDocxNames.length; ++i) {
            String filename = BASE_DIR + sourceDocxNames[i];
            System.out.println("Loading " + filename);
            wmlPkgList.add(WordprocessingMLPackage.load(new File(filename)));
        }
        try {
            Class<?> documentBuilder = Class.forName("com.plutext.merge.DocumentBuilder");
            Method[] methods = documentBuilder.getMethods();
            Method method = null;
            for (int j = 0; j < methods.length; ++j) {
                System.out.println(methods[j].getName());
                if (!methods[j].getName().equals("merge")) continue;
                method = methods[j];
                break;
            }
            if (method == null) {
                throw new NoSuchMethodException();
            }
            WordprocessingMLPackage resultPkg = (WordprocessingMLPackage)method.invoke(null, wmlPkgList);
            if (save) {
                SaveToZipFile saver = new SaveToZipFile(resultPkg);
                saver.save(outputfilepath);
                System.out.println("Generated " + outputfilepath);
            } else {
                String result = XmlUtils.marshaltoString(resultPkg.getMainDocumentPart().getJaxbElement(), true, true);
                System.out.println(result);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            MergeDocx.extensionMissing(e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            MergeDocx.extensionMissing(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void extensionMissing(Exception e) {
        System.out.println("\n" + e.getClass().getName() + ": " + e.getMessage() + "\n");
        System.out.println("* You don't appear to have the MergeDocx paid extension,");
        System.out.println("* which is necessary to merge docx, or process altChunks (of type docx).");
        System.out.println("* Purchases of this extension support the docx4j project.");
        System.out.println("* Please visit www.plutext.com if you want to buy it.");
    }
}

