/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.samples.AbstractSample;

public class PartsList
extends AbstractSample {
    private static Logger log = Logger.getLogger(PartsList.class);
    public static HashMap<Part, Part> handled = new HashMap();

    public static void main(String[] args) throws Exception {
        boolean printContentTypes = true;
        try {
            PartsList.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/chart.docx";
        }
        OpcPackage opcPackage = OpcPackage.load(new File(inputfilepath));
        if (printContentTypes) {
            PartsList.printContentTypes(opcPackage);
        }
        RelationshipsPart rp = opcPackage.getRelationshipsPart();
        StringBuilder sb = new StringBuilder();
        PartsList.printInfo(rp, sb, "");
        PartsList.traverseRelationships(opcPackage, rp, sb, "    ");
        System.out.println(sb.toString());
    }

    public static void printContentTypes(OpcPackage p) {
        ContentTypeManager ctm = p.getContentTypeManager();
        System.out.println(ctm.toString());
    }

    public static void printInfo(Part p, StringBuilder sb, String indent) {
        String relationshipType = "";
        if (p.getSourceRelationships().size() > 0) {
            relationshipType = p.getSourceRelationships().get(0).getType();
        }
        sb.append("\n" + indent + "Part " + p.getPartName() + " [" + p.getClass().getName() + "] " + relationshipType);
        if (p instanceof JaxbXmlPart) {
            Object o = ((JaxbXmlPart)p).getJaxbElement();
            if (o instanceof JAXBElement) {
                sb.append(" containing JaxbElement:" + XmlUtils.JAXBElementDebug((JAXBElement)o));
            } else {
                sb.append(" containing JaxbElement:" + o.getClass().getName());
            }
        }
    }

    public static void traverseRelationships(OpcPackage wordMLPackage, RelationshipsPart rp, StringBuilder sb, String indent) {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.info((Object)("\nFor Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget() + " type " + r.getType() + "\n"));
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                sb.append("\n" + indent + "external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            Part part = rp.getPart(r);
            PartsList.printInfo(part, sb, indent);
            if (handled.get(part) != null) {
                sb.append(" [additional reference] ");
                continue;
            }
            handled.put(part, part);
            if (part.getRelationshipsPart(false) == null) continue;
            PartsList.traverseRelationships(wordMLPackage, part.getRelationshipsPart(false), sb, indent + "    ");
        }
    }
}

