/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.xpathextend.grammar;

import org.docx4j.model.datastorage.XPathEnhancerParser;
import org.docx4j.xpathextend.grammar.XPathConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class XPathEnhancerTest {
    private static final XPathConfiguration SIMPLE = new XPathConfiguration("/prefix", 12);
    private static final XPathConfiguration COMPLICATED = new XPathConfiguration("/doc[17]/baskets/basket", 78);

    @Test
    public void testExtensions() {
        this.assertUnchanged(SIMPLE, "/somewhere/else");
        this.assertUnchanged(SIMPLE, "/short");
        this.assertUnchanged(SIMPLE, "/");
        this.assertChanged(SIMPLE, "/prefix", "/prefix[12]");
        this.assertChanged(SIMPLE, "/prefix/further", "/prefix[12]/further");
        this.assertChanged(SIMPLE, "/prefix/further/@hand", "/prefix[12]/further/@hand");
        this.assertUnchanged(SIMPLE, "string(/prefi/*[5])='got'");
        this.assertChanged(SIMPLE, "string(/prefix/property) = 'wisdom' and boolean(/prefix/imaginary)", "string(/prefix[12]/property) = 'wisdom' and boolean(/prefix[12]/imaginary)");
        this.assertChanged(COMPLICATED, "/doc[17]/baskets/basket/hay", "/doc[17]/baskets/basket[78]/hay");
    }

    private void assertUnchanged(XPathConfiguration config, String xpath) {
        Assert.assertEquals((Object)xpath, (Object)this.enhance(config, xpath));
    }

    private void assertChanged(XPathConfiguration config, String xpath, String newVersion) {
        String enhanced = this.enhance(config, xpath);
        Assert.assertFalse((boolean)xpath.equals(enhanced));
        if (newVersion != null) {
            Assert.assertEquals((Object)newVersion, (Object)enhanced);
        }
    }

    private String enhance(XPathConfiguration config, String xpath) {
        String enhanced = XPathEnhancerParser.enhanceXPath(config.getPrefix(), config.getIndex(), xpath);
        return enhanced;
    }
}

