/*
 * Decompiled with CFR 0.152.
 */
package org.glox4j.samples;

import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.dml.diagram.CTDescription;
import org.docx4j.dml.diagram.CTDiagramDefinition;
import org.docx4j.dml.diagram.CTDiagramDefinitionHeader;
import org.docx4j.dml.diagram.CTName;
import org.docx4j.dml.diagram.ObjectFactory;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutHeaderPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.samples.AbstractSample;
import org.glox4j.openpackaging.packages.GloxPackage;

public class ExtractGloxFromExemplar
extends AbstractSample {
    private static Logger log = Logger.getLogger(ExtractGloxFromExemplar.class);

    public static void main(String[] args) throws Exception {
        try {
            ExtractGloxFromExemplar.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/glox/extracted/CirclePictureHierarchy.docx";
        }
        String outputdir = inputfilepath.substring(0, inputfilepath.lastIndexOf("/") + 1);
        String outputfilename = inputfilepath.substring(inputfilepath.lastIndexOf("/")) + ".glox";
        OpcPackage opcPackage = OpcPackage.load(new File(inputfilepath));
        GloxPackage gloxPackage = new GloxPackage();
        JaxbXmlPart source = null;
        for (Map.Entry<PartName, Part> entry : opcPackage.getParts().getParts().entrySet()) {
            if (!entry.getValue().getContentType().equals("application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml")) continue;
            source = (DiagramLayoutPart)entry.getValue();
            break;
        }
        if (source == null) {
            System.out.println("No SmartArt found in " + inputfilepath);
            return;
        }
        DiagramLayoutPart target = new DiagramLayoutPart(new PartName("/diagrams/layout1.xml"));
        target.setJaxbElement(XmlUtils.deepCopy(source.getJaxbElement()));
        gloxPackage.addTargetPart(target);
        DiagramLayoutHeaderPart diagramLayoutHeaderPart = new DiagramLayoutHeaderPart();
        ObjectFactory factory = new ObjectFactory();
        CTDiagramDefinitionHeader header = factory.createCTDiagramDefinitionHeader();
        diagramLayoutHeaderPart.setJaxbElement(header);
        String uniqueId = ((CTDiagramDefinition)target.getJaxbElement()).getUniqueId();
        if (uniqueId != null) {
            header.setUniqueId(uniqueId);
            System.out.println("Creating glox for " + uniqueId);
            if (uniqueId.indexOf("/") > 0 && uniqueId.lastIndexOf("/") != uniqueId.length() - 1) {
                outputfilename = uniqueId.substring(uniqueId.lastIndexOf("/") + 1) + ".glox";
            }
        }
        if (((CTDiagramDefinition)target.getJaxbElement()).getTitle() == null || ((CTDiagramDefinition)target.getJaxbElement()).getTitle().isEmpty() || ((CTDiagramDefinition)target.getJaxbElement()).getTitle().size() == 1 && ((CTDiagramDefinition)target.getJaxbElement()).getTitle().get(0).getVal().isEmpty()) {
            CTName title = factory.createCTName();
            title.setVal("some title");
            header.getTitle().add(title);
        } else {
            header.getTitle().addAll(((CTDiagramDefinition)target.getJaxbElement()).getTitle());
        }
        if (((CTDiagramDefinition)target.getJaxbElement()).getDesc() == null || ((CTDiagramDefinition)target.getJaxbElement()).getDesc().isEmpty() || ((CTDiagramDefinition)target.getJaxbElement()).getDesc().size() == 1 && ((CTDiagramDefinition)target.getJaxbElement()).getDesc().get(0).getVal().isEmpty()) {
            CTDescription desc = factory.createCTDescription();
            desc.setVal("some desc");
            header.getDesc().add(desc);
        } else {
            header.getDesc().addAll(((CTDiagramDefinition)target.getJaxbElement()).getDesc());
        }
        gloxPackage.addTargetPart(diagramLayoutHeaderPart);
        String outfile = outputdir + outputfilename;
        System.out.println("Writing " + outfile);
        gloxPackage.save(new File(outfile));
        System.out.println("Done!");
    }
}

