/*
 * Decompiled with CFR 0.152.
 */
package org.pptx4j.samples;

import java.io.FileInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.xmlPackage.Package;

public class ImportFromPackageFormat {
    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/xls.xml";
        FileInputStream fin = new FileInputStream(inputfilepath);
        boolean save = true;
        String outputfilepath = inputfilepath + ".pptx";
        try {
            JAXBContext jc = Context.jcXmlPackage;
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Package wmlPackageEl = (Package)((JAXBElement)u.unmarshal((Source)new StreamSource(new FileInputStream(inputfilepath)))).getValue();
            FlatOpcXmlImporter xmlPackage = new FlatOpcXmlImporter(wmlPackageEl);
            PresentationMLPackage pmlPackage = (PresentationMLPackage)xmlPackage.get();
            if (save) {
                SaveToZipFile saver = new SaveToZipFile(pmlPackage);
                saver.save(outputfilepath);
                System.out.println("\n\n .. written to " + outputfilepath);
            } else {
                System.out.println("\n\n..done ");
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
    }
}

