/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.component.std.config.FormConfig;
import aurora.presentation.component.std.config.TextFieldConfig;
import aurora.service.ServiceContext;
import java.io.IOException;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.event.Configuration;
import uncertain.proc.IFeature;
import uncertain.proc.ProcedureRunner;

public class AutoForm
implements IFeature {
    private static final String PROPERTITY_MODEL = "model";
    private static final String PROPERTITY_ENTERDOWN_HANDLER = "enterdownhandler";
    IDatabaseServiceFactory mFactory;
    CompositeMap view;

    public AutoForm(IDatabaseServiceFactory factory) {
        this.mFactory = factory;
    }

    public int onCreateView(ProcedureRunner runner) throws IOException {
        ServiceContext sc = ServiceContext.createServiceContext(runner.getContext());
        CompositeMap model = sc.getModel();
        FormConfig formConfig = FormConfig.getInstance(this.view);
        formConfig.setCellSpacing(0);
        String target = this.view.getString((Object)"bindtarget", "");
        String handler = this.view.getString((Object)PROPERTITY_ENTERDOWN_HANDLER);
        String labelWidth = TextParser.parse((String)this.view.getString((Object)"labelwidth"), (CompositeMap)model);
        formConfig.put("labelwidth", "".equals(labelWidth) ? null : labelWidth);
        String href = this.view.getString((Object)PROPERTITY_MODEL, "");
        if (!"".equals(href)) {
            href = TextParser.parse((String)href, (CompositeMap)model);
            BusinessModelService modelService = this.mFactory.getModelService(href);
            BusinessModel bm = modelService.getBusinessModel();
            Field[] fields = bm.getFields();
            int fl = fields.length;
            int n = 0;
            while (n < fl) {
                Field field = fields[n];
                if (field.isForQuery()) {
                    TextFieldConfig textField = TextFieldConfig.getInstance(field.getObjectContext());
                    textField.setWidth(field.getQueryWidth());
                    if (!"".equals(target)) {
                        textField.setBindTarget(target);
                    }
                    if (handler != null) {
                        EventConfig ec = EventConfig.getInstance();
                        ec.setEventName("enterdown");
                        ec.setHandler(handler);
                        textField.addEvent(ec);
                    }
                    formConfig.addChild(textField.getObjectContext());
                }
                ++n;
            }
        }
        this.view.getParent().replaceChild(this.view, formConfig.getObjectContext());
        return 0;
    }

    public int attachTo(CompositeMap v, Configuration procConfig) {
        this.view = v;
        return 0;
    }
}

