/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.ICacheProvider;
import aurora.application.features.cache.IEventHandler;
import aurora.application.features.cache.RecordReloadHandler;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.service.IServiceFactory;
import java.util.logging.Level;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.util.resource.ILocatable;

public class EntityReloadHandler
extends RecordReloadHandler {
    private String operations;
    private String entity;

    @Override
    public void init(ICacheProvider provider, IObjectRegistry registry) {
        this.provider = provider;
        if (this.entity == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"entity");
        }
        IMessageStub stub = (IMessageStub)registry.getInstanceOfType(IMessageStub.class);
        if (stub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IMessageStub.class, (String)this.getClass().getName());
        }
        IConsumer consumer = stub.getConsumer(this.topic);
        if (!(consumer instanceof INoticerConsumer)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException((String)this.getOriginSource(), INoticerConsumer.class, IConsumer.class);
        }
        this.dsFactory = (IDatabaseServiceFactory)registry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.dsFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, DatabaseServiceFactory.class, (String)this.getClass().getName());
        }
        if (this.operations == null) {
            StringBuffer sb = new StringBuffer("");
            int j = 0;
            while (j < IEventHandler.OPERATIONS.values().length) {
                if (j > 0) {
                    sb.append(",");
                }
                sb.append(IEventHandler.OPERATIONS.values()[j].name());
                ++j;
            }
            this.setOperations(sb.toString());
        }
        String[] stringArray = this.getOperations().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            String message = String.valueOf(this.getEntity().toLowerCase()) + "/" + op;
            ((INoticerConsumer)consumer).addListener(message, this);
            ++n2;
        }
        this.logger = LoggingContext.getLogger((String)this.getClass().getCanonicalName(), (IObjectRegistry)registry);
        this.procedureManager = (IProcedureManager)registry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IProcedureManager.class, (String)this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)registry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IServiceFactory.class, (String)this.getClass().getName());
        }
    }

    public String getOperations() {
        return this.operations;
    }

    public void setOperations(String operations) {
        this.operations = operations;
    }

    @Override
    public void onMessage(IMessage message) {
        this.beginCacheTransaction();
        try {
            if (message == null) {
                throw new IllegalArgumentException(" message can't be null!");
            }
            String text = message.getText();
            if (text == null) {
                throw new IllegalArgumentException(" Can't get text form message!");
            }
            String[] parts = text.split("/");
            String operation = parts[parts.length - 1];
            if (IEventHandler.OPERATIONS.delete.name().equals(operation)) {
                this.delete(message);
            } else if (IEventHandler.OPERATIONS.update.name().equals(operation)) {
                this.update(message);
            } else if (IEventHandler.OPERATIONS.insert.name().equals(operation)) {
                this.insert(message);
            } else if (IEventHandler.OPERATIONS.reload.name().equals(operation)) {
                this.reload(message);
            } else {
                throw new IllegalArgumentException("operation:" + operation + " not support!");
            }
            this.commitCache();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "handle message exception", (Throwable)e);
            this.rollbackCache();
        }
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }
}

