/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureConfigManager;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class AsyncTask
extends AbstractEntry {
    private IDatabaseServiceFactory mDatabaseServiceFactory;
    private String bm;
    private String taskName;
    private String taskDescription;
    private String executorInstance;
    private String procFilePath;
    private String procContent;
    private String context;
    private int priority;
    private String taskType;
    private String sql;
    private int retryTime;
    private int timeOut;
    private IObjectRegistry objectRegistry;

    public AsyncTask(IObjectRegistry objectRegistry, IDatabaseServiceFactory databaseServiceFactory) {
        this.objectRegistry = objectRegistry;
        this.mDatabaseServiceFactory = databaseServiceFactory;
    }

    public void run(ProcedureRunner runner) throws Exception {
        this.execute(runner.getContext());
    }

    public void execute(CompositeMap context) throws Exception {
        CompositeMap parameters;
        SqlServiceContext sqlServiceContext = (SqlServiceContext)((Object)DynamicObject.cast((CompositeMap)context, SqlServiceContext.class));
        sqlServiceContext.initConnection(this.objectRegistry, null);
        CompositeMap contextClone = (CompositeMap)context.clone();
        String strContext = contextClone.toXML();
        if (this.bm == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"bm");
        }
        this.bm = TextParser.parse((String)this.bm, (CompositeMap)contextClone);
        if (this.taskType == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"taskType");
        }
        this.taskType = TextParser.parse((String)this.taskType, (CompositeMap)contextClone);
        if ("JAVA".equals(this.taskType)) {
            if (this.procFilePath == null && this.procContent == null) {
                throw BuiltinExceptionFactory.createOneAttributeMissing((ILocatable)this, (String)"procFilePath,procContent");
            }
            if (this.procFilePath != null && this.procContent != null) {
                throw BuiltinExceptionFactory.createConflictAttributesExcepiton((ILocatable)this, (String)"procFilePath,procContent");
            }
            this.procFilePath = TextParser.parse((String)this.procFilePath, (CompositeMap)contextClone);
        }
        if ("PROCEDURE".equals(this.taskType) || "FUNCTION".equals(this.taskType)) {
            if (this.sql == null) {
                throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"taskType");
            }
            this.sql = TextParser.parse((String)this.sql, (CompositeMap)contextClone);
        }
        if ((parameters = contextClone.getChild("parameter")) == null) {
            parameters = new CompositeMap("parameter");
            contextClone.addChild(parameters);
        }
        parameters.put((Object)"task_name", (Object)this.taskName);
        parameters.put((Object)"task_description", (Object)this.taskDescription);
        parameters.put((Object)"executor_instance", (Object)this.executorInstance);
        parameters.put((Object)"proc_file_path", (Object)this.procFilePath);
        parameters.put((Object)"proc_content", (Object)this.procContent);
        parameters.put((Object)"context", (Object)strContext);
        parameters.put((Object)"priority", (Object)this.priority);
        parameters.put((Object)"task_type", (Object)this.taskType);
        parameters.put((Object)"retry_time", (Object)this.retryTime);
        parameters.put((Object)"time_out", (Object)this.timeOut);
        BusinessModelService businessModelService = this.mDatabaseServiceFactory.getModelService(this.bm, contextClone);
        businessModelService.execute((Map)parameters);
    }

    public String getBm() {
        return this.bm;
    }

    public void setBm(String bm) {
        this.bm = bm;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public String getExecutorInstance() {
        return this.executorInstance;
    }

    public void setExecutorInstance(String executorInstance) {
        this.executorInstance = executorInstance;
    }

    public String getProcFilePath() {
        return this.procFilePath;
    }

    public void setProcFilePath(String procFilePath) {
        this.procFilePath = procFilePath;
    }

    public String getProcContent() {
        return this.procContent;
    }

    public void setProcContent(String procContent) {
        this.procContent = procContent;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public void beginConfigure(CompositeMap config) {
        List childs = config.getChilds();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        CompositeMap proc_config = ProcedureConfigManager.createConfigNode((String)"procedure");
        proc_config.addChilds((Collection)config.getChilds());
        this.procContent = proc_config.toXML();
    }
}

