/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.database.sql.StringConcatenater;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.util.StringSplitter;

public class DataFilter
extends DynamicObject {
    public static final String KEY_NAME = "name";
    public static final String KEY_EXPRESSION = "expression";
    public static final String KEY_ENFORCE_OPERATIONS = "enforceoperations";
    public static final String KEY_DATA_FILTERS = "data-filters";

    public static DataFilter getInstance(CompositeMap map) {
        DataFilter filter = new DataFilter();
        filter.initialize(map);
        return filter;
    }

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    public String getExpression() {
        String exp = this.getString(KEY_EXPRESSION);
        if (exp == null) {
            exp = this.getObjectContext().getText();
        }
        return exp;
    }

    public void setExpression(String exp) {
        this.getObjectContext().setText(exp);
    }

    public String[] getEnforceOperations() {
        String s = this.getString(KEY_ENFORCE_OPERATIONS);
        if (s == null) {
            return null;
        }
        return StringSplitter.splitToArray((String)s, (char)',', (boolean)true);
    }

    public void setEnforceOperations(String[] actions) {
        StringConcatenater sc = new StringConcatenater(",");
        int i = 0;
        while (i < actions.length) {
            sc.append(actions[i]);
            ++i;
        }
        this.putString(KEY_ENFORCE_OPERATIONS, sc.getContent());
    }
}

