/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.Field;
import aurora.database.sql.AbstractStatement;
import aurora.database.sql.CompareExpression;
import aurora.database.sql.ConditionList;
import aurora.database.sql.ILogicalExpression;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.RawSqlExpression;
import uncertain.composite.DynamicObject;
import uncertain.core.ConfigurationError;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.util.resource.ILocatable;

public class QueryField
extends DynamicObject {
    public static final String KEY_LOGICAL_OPERATOR = "logicaloperator";
    public static final String KEY_FIELD = "field";
    public static final String KEY_NAME = "name";
    public static final String KEY_QUERY_OPERATOR = "queryoperator";
    public static final String KEY_MATCH_ANY = "matchany";

    public boolean getMatchAny() {
        return this.getBoolean(KEY_MATCH_ANY, false);
    }

    public void setMatchAny(boolean value) {
        this.putBoolean(KEY_MATCH_ANY, value);
    }

    public String getQueryOperator() {
        return this.getString(KEY_QUERY_OPERATOR);
    }

    public void setQueryOperator(String op) {
        this.putString(KEY_QUERY_OPERATOR, op);
    }

    public String getField() {
        return this.getString(KEY_FIELD);
    }

    public void setField(String field) {
        this.putString(KEY_FIELD, field);
    }

    public String getQueryExpression() {
        return this.getString("queryexpression");
    }

    public void setQueryExpression(String exp) {
        this.putString("queryexpression", exp);
    }

    public String getLogicalOperator() {
        return this.getString(KEY_LOGICAL_OPERATOR);
    }

    public void setLogicalOperator(String op) {
        this.putString(KEY_LOGICAL_OPERATOR, op);
    }

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    public void addToWhereClause(ConditionList list, String param_path) {
        this.addToWhereClause(list, null, param_path);
    }

    public void addToWhereClause(ConditionList list, ISqlStatement left_field, String param_path) {
        String op = this.getQueryOperator();
        AbstractStatement stmt = null;
        if (op != null) {
            int op_id = CompareExpression.getOperatorID(op);
            if (op_id < 0) {
                throw new ConfigurationError("queryOperator '" + op + "' is invalid in query field config:" + this.getObjectContext().toXML());
            }
            if (CompareExpression.isSingleOperator(op_id)) {
                stmt = new CompareExpression(left_field, op_id, null);
            } else {
                String sqlExpression = Field.defaultParamExpression(param_path);
                if (this.getMatchAny() && "like".equalsIgnoreCase(op)) {
                    sqlExpression = "'%'||" + sqlExpression + "||'%'";
                }
                stmt = new CompareExpression(left_field, op_id, new RawSqlExpression(sqlExpression));
            }
        } else {
            String exp = this.getQueryExpression();
            if (exp != null) {
                stmt = new RawSqlExpression(exp);
            } else {
                throw BuiltinExceptionFactory.createOneAttributeMissing((ILocatable)this.getObjectContext().asLocatable(), (String)"queryOperator,queryExpression");
            }
        }
        String logical_op = this.getLogicalOperator();
        if (logical_op == null) {
            logical_op = "AND";
        }
        if (stmt != null) {
            list.addCondition(logical_op, (ILogicalExpression)((Object)stmt));
        }
    }
}

