/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.database.SqlRunner;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.ocm.OCManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class BatchApply
extends Procedure {
    String mSourcePath;

    public BatchApply() {
    }

    public BatchApply(OCManager ocm) {
        super(ocm);
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap map = runner.getContext();
        ILogger logger = DatabaseServiceFactory.getLogger(map);
        SqlServiceContext svcContext = SqlServiceContext.createSqlServiceContext(map);
        CompositeMap old_current_param = svcContext.getCurrentParameter();
        Collection records = SqlRunner.getSourceParameter(map, this.mSourcePath);
        if (records != null) {
            logger.log(Level.CONFIG, "Running batch-apply with data from path {0}, total {1} records", new Object[]{this.mSourcePath, new Integer(records.size())});
            Iterator it = records.iterator();
            int mod_count = 0;
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == null) {
                    logger.config("Record No." + mod_count + " is null");
                    continue;
                }
                if (!(obj instanceof CompositeMap)) {
                    throw new IllegalStateException("item in batch source collection should be instance of CompositeMap: " + obj);
                }
                CompositeMap item = (CompositeMap)obj;
                svcContext.setCurrentParameter((Map)item);
                logger.config("Executing batch-apply on parameter No." + mod_count);
                ++mod_count;
                super.run(runner);
            }
            if (mod_count > 0) {
                svcContext.setCurrentParameter((Map)old_current_param);
            }
        } else {
            logger.info("[batch-apply] Data from '" + this.mSourcePath + "' is null");
        }
    }

    public String getSourcePath() {
        return this.mSourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.mSourcePath = sourcePath;
    }
}

