/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.bm.BusinessModel;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.actions.AbstractQueryAction;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.DatabaseServiceFactory;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.util.resource.ILocatable;

public class ModelQuery
extends AbstractQueryAction {
    String model;
    DatabaseServiceFactory svcFactory;
    BusinessModelService service;
    BusinessModelServiceContext serviceContext;

    public ModelQuery(DatabaseServiceFactory svcFactory, OCManager manager, IObjectRegistry reg) {
        super(manager, reg);
        this.svcFactory = svcFactory;
    }

    public BusinessModelService getService() {
        return this.service;
    }

    public DatabaseServiceFactory getServiceFactory() {
        return this.svcFactory;
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return String.valueOf(super.getName()) + "[" + this.getModel() + "]";
    }

    @Override
    protected void doQuery(CompositeMap param, IResultSetConsumer consumer, FetchDescriptor desc) throws Exception {
        if (this.getAttribFromRequest()) {
            BusinessModel bm = this.service.getBusinessModel();
            if (bm.getAllowFetchAll() != null && !bm.getAllowFetchAll().booleanValue()) {
                this.fetchAll = false;
                desc.setFetchAll(this.fetchAll);
            }
            if (!this.fetchAll) {
                int maxPageSize = -1;
                if (bm.getMaxPageSize() != null) {
                    maxPageSize = bm.getMaxPageSize();
                } else {
                    Object defaultPageSize = this.svcFactory.getDatabaseFactory().getProperty("maxpagesize");
                    if (defaultPageSize != null) {
                        maxPageSize = Integer.parseInt((String)defaultPageSize);
                    }
                }
                if (maxPageSize != -1 && desc.getPageSize() > maxPageSize && this.pageSize == null) {
                    desc.setPageSize(maxPageSize);
                }
            }
        }
        this.service.query((Map)param, consumer, desc);
    }

    @Override
    protected void prepare(CompositeMap context) throws Exception {
        if (this.model == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"model");
        }
        ILogger logger = LoggingContext.getLogger((CompositeMap)context, (String)"aurora.database");
        String parsed_model = TextParser.parse((String)this.model, (CompositeMap)context);
        logger.config("===================================== prepare to run model-query " + parsed_model + "==============================");
        this.service = this.svcFactory.getModelService(parsed_model, context);
        this.setConnectionName(this.service.getBusinessModel().getDataSourceName());
        this.serviceContext = (BusinessModelServiceContext)((Object)DynamicObject.cast((CompositeMap)context, BusinessModelServiceContext.class));
    }

    @Override
    protected void cleanUp(CompositeMap context) {
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
    }
}

