/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource;

import aurora.security.crypto.encrypt.TextEncryptor;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Properties;
import uncertain.composite.CompositeMap;

public class DatabaseConnection {
    String name;
    String driverClass;
    String url;
    String userName;
    String password;
    String initSql;
    boolean pool = true;
    String jndiName;
    String containerName = "WEBLOGIC";
    int listenerPort = 7001;
    String passwordEncryptorClass;
    CompositeMap config = null;
    Properties properties = new Properties();

    public String getInitSql() {
        return this.initSql;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        try {
            String className = this.getPasswordEncryptorClass();
            if (className != null) {
                TextEncryptor encryptor = (TextEncryptor)Class.forName(className).newInstance();
                return encryptor.decrypt(this.password);
            }
            return this.password;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean getPool() {
        return this.pool;
    }

    public void setPool(boolean pool) {
        this.pool = pool;
    }

    public CompositeMap getConfig() {
        return this.config;
    }

    public void setConfig(CompositeMap config) {
        this.config = config;
    }

    public Properties getPoolProperties() {
        return this.properties;
    }

    public void addProperties(CompositeMap config) throws Exception {
        String text = config.getText();
        ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF-8"));
        this.properties.load(stream);
        Enumeration<?> enumn = this.properties.propertyNames();
        if (enumn != null) {
            this.config = new CompositeMap();
            while (enumn.hasMoreElements()) {
                String key = (String)enumn.nextElement();
                this.config.put((Object)key, (Object)this.properties.getProperty(key).trim());
            }
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public void setListenerPort(int listenerPort) {
        this.listenerPort = listenerPort;
    }

    public String getPasswordEncryptorClass() {
        return this.passwordEncryptorClass;
    }

    public void setPasswordEncryptorClass(String passwordEncryptorClass) {
        this.passwordEncryptorClass = passwordEncryptorClass;
    }
}

