/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics;

import aurora.ide.api.statistics.SQL;
import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.Status;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.Dependency;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.api.statistics.model.Tag;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseAction
implements SQL {
    private StatisticsProject project;
    private List<ProjectObject> poList;
    private StatisticsResult result;
    private Map<Integer, ProjectObject> poMap;
    private int BATCH_SIZE = 10000;
    private Map<String, List<String>> reference = new HashMap<String, List<String>>();
    private Map<String, Integer> referenced = new HashMap<String, Integer>();

    public DatabaseAction(Statistician statistician) {
        this.project = statistician.getProject();
        this.poList = statistician.getPoList();
    }

    private void saveProject(Connection connection) throws SQLException {
        PreparedStatement prepareStatement = null;
        try {
            prepareStatement = connection.prepareStatement("INSERT INTO statistics_project (id,projectName,storer,storeDate,repositoryType,repositoryRevision,repositoryPath)  VALUES (?,?,?,sysdate,?,?,?)");
            prepareStatement.setInt(1, Integer.valueOf(this.project.getProjectId()));
            prepareStatement.setString(2, this.project.getProjectName());
            prepareStatement.setString(3, this.project.getStorer());
            prepareStatement.setString(4, this.project.getRepositoryType());
            prepareStatement.setString(5, this.project.getRepositoryRevision());
            prepareStatement.setString(6, this.project.getRepositoryPath());
            prepareStatement.execute();
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setObjectID(Connection connection, ProjectObject po) {
        String selectProjectID = "SELECT project_object_s.nextval from dual ";
        try {
            PreparedStatement prepareStatement = connection.prepareStatement(selectProjectID);
            int objectID = prepareStatement.executeQuery().getInt(1);
            po.setObjectId(String.valueOf(objectID));
        }
        catch (SQLException e) {
            po.setObjectId("-1");
        }
    }

    private void saveObjects(int partSize, Connection connection, int maxObjectID) throws SQLException {
        PreparedStatement prepareStatement = null;
        int count = 0;
        try {
            prepareStatement = connection.prepareStatement("INSERT INTO project_object (id,project_id,type,name,path,file_size,script_size)  VALUES (?,?,?,?,?,?,?)");
            for (ProjectObject po : this.poList) {
                po.setObjectId(String.valueOf(maxObjectID++));
                po.setProjectId(this.project.getProjectId());
                prepareStatement.setInt(1, Integer.valueOf(po.getObjectId()));
                prepareStatement.setInt(2, Integer.valueOf(po.getProjectId()));
                prepareStatement.setString(3, po.getType());
                prepareStatement.setString(4, po.getName());
                prepareStatement.setString(5, po.getPath());
                prepareStatement.setInt(6, po.getFileSize());
                prepareStatement.setInt(7, po.getScriptSize());
                prepareStatement.addBatch();
                if (++count < partSize) continue;
                prepareStatement.executeBatch();
                prepareStatement.close();
                prepareStatement = connection.prepareStatement("INSERT INTO project_object (id,project_id,type,name,path,file_size,script_size)  VALUES (?,?,?,?,?,?,?)");
                count = 0;
            }
            if (count > 0) {
                prepareStatement.executeBatch();
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveTags(int partSize, Connection connection) throws SQLException {
        PreparedStatement prepareStatement = null;
        try {
            prepareStatement = connection.prepareStatement("INSERT INTO object_tag (id,object_id,project_id,type,name,namespace,qName,rawName,prefix,count,tag_size)VALUES (object_tag_s.nextval,?,?,?,?,?,?,?,?,?,?)");
            int count = 0;
            for (ProjectObject po : this.poList) {
                List<Tag> tags = po.getTags();
                for (Tag tag : tags) {
                    prepareStatement.setInt(1, Integer.valueOf(po.getObjectId()));
                    prepareStatement.setInt(2, Integer.valueOf(po.getProjectId()));
                    prepareStatement.setString(3, tag.getType());
                    prepareStatement.setString(4, tag.getName());
                    prepareStatement.setString(5, tag.getNamespace());
                    prepareStatement.setString(6, tag.getqName());
                    prepareStatement.setString(7, tag.getRawName());
                    prepareStatement.setString(8, tag.getPrefix());
                    prepareStatement.setInt(9, tag.getCount());
                    prepareStatement.setInt(10, tag.getSize());
                    prepareStatement.addBatch();
                    ++count;
                }
                if (count < partSize) continue;
                prepareStatement.executeBatch();
                prepareStatement.close();
                prepareStatement = connection.prepareStatement("INSERT INTO object_tag (id,object_id,project_id,type,name,namespace,qName,rawName,prefix,count,tag_size)VALUES (object_tag_s.nextval,?,?,?,?,?,?,?,?,?,?)");
                count = 0;
            }
            if (count > 0) {
                prepareStatement.executeBatch();
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectAll(Connection connection) throws SQLException {
        String string;
        ResultSet executeQuery;
        String s1 = "select * from statistics_project";
        String s2 = "select * from project_object";
        String s3 = "select * from object_tag";
        String s4 = "select * from object_dependency";
        PreparedStatement prepareStatement = null;
        try {
            prepareStatement = connection.prepareStatement(s1);
            executeQuery = prepareStatement.executeQuery();
            while (executeQuery.next()) {
                string = executeQuery.getString(5);
                System.out.println("statistics_project index5 : ");
                System.out.println(string);
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            prepareStatement = connection.prepareStatement(s2);
            executeQuery = prepareStatement.executeQuery();
            while (executeQuery.next()) {
                string = executeQuery.getString(5);
                System.out.println("Project Object index5 : ");
                System.out.println(string);
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            prepareStatement = connection.prepareStatement(s3);
            executeQuery = prepareStatement.executeQuery();
            while (executeQuery.next()) {
                string = executeQuery.getString(5);
                System.out.println("Object tags index5 : ");
                System.out.println(string);
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            prepareStatement = connection.prepareStatement(s4);
            executeQuery = prepareStatement.executeQuery();
            while (executeQuery.next()) {
                string = executeQuery.getString(5);
                System.out.println("Object tags index5 : ");
                System.out.println(string);
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveDependencies(Connection connection) throws SQLException {
        PreparedStatement prepareStatement = null;
        try {
            prepareStatement = connection.prepareStatement("INSERT INTO object_dependency (id,object_id,project_id,dependency_object_id)VALUES (object_dependency_s.nextval,?,?,?)");
            for (ProjectObject po : this.poList) {
                List<Dependency> dependencies = po.getDependencies();
                for (Dependency d : dependencies) {
                    prepareStatement.setInt(1, Integer.valueOf(d.getObjectID()));
                    prepareStatement.setInt(2, Integer.valueOf(po.getProjectId()));
                    prepareStatement.setInt(3, Integer.valueOf(d.getDependencyObjectID()));
                    prepareStatement.addBatch();
                }
            }
            prepareStatement.executeBatch();
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static StatisticsProject[] readAllProject(Connection connection) throws SQLException {
        ArrayList<StatisticsProject> ps;
        block15: {
            ps = new ArrayList<StatisticsProject>();
            Statement prepareStatement = null;
            try {
                try {
                    prepareStatement = connection.createStatement();
                    ResultSet rs = prepareStatement.executeQuery("SELECT * FROM statistics_project");
                    while (rs.next()) {
                        int dID = rs.getInt(1);
                        String projectName = rs.getString(2);
                        String storer = rs.getString(3);
                        Date storeDate = rs.getDate(4);
                        String repositoryType = rs.getString(5);
                        String repositoryRevision = rs.getString(6);
                        String repositoryPath = rs.getString(7);
                        StatisticsProject project = new StatisticsProject(projectName);
                        project.setProjectId(String.valueOf(dID));
                        project.setRepositoryPath(repositoryPath);
                        project.setRepositoryRevision(repositoryRevision);
                        project.setRepositoryType(repositoryType);
                        project.setStoreDate(DateFormat.getDateInstance(2).format(storeDate));
                        project.setStorer(storer);
                        ps.add(project);
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    if (prepareStatement != null) {
                        try {
                            prepareStatement.close();
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (prepareStatement != null) {
                    try {
                        prepareStatement.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return ps.toArray(new StatisticsProject[ps.size()]);
    }

    public static void dropTables(Connection connection) {
        block12: {
            Statement prepareStatement = null;
            try {
                try {
                    prepareStatement = connection.createStatement();
                    prepareStatement.addBatch("DROP SEQUENCE object_dependency_s");
                    prepareStatement.addBatch("DROP TABLE object_dependency");
                    prepareStatement.addBatch("DROP TABLE project_object");
                    prepareStatement.addBatch("DROP SEQUENCE statistics_project_s");
                    prepareStatement.addBatch("DROP TABLE statistics_project");
                    prepareStatement.addBatch("DROP SEQUENCE object_tag_s");
                    prepareStatement.addBatch("DROP TABLE object_tag");
                    prepareStatement.executeBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (prepareStatement == null) break block12;
                    try {
                        prepareStatement.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (prepareStatement != null) {
                    try {
                        prepareStatement.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void createTables(Connection connection) {
        block12: {
            Statement prepareStatement = null;
            try {
                try {
                    prepareStatement = connection.createStatement();
                    prepareStatement.addBatch("CREATE TABLE statistics_project (id number,projectName varchar2(100),storer varchar2 (200),storeDate date,repositoryType varchar2(100),repositoryRevision varchar2(100),repositoryPath varchar2(256))");
                    prepareStatement.addBatch("CREATE TABLE project_object( id number,project_id number,type varchar2(100),name varchar2(200),path varchar2(256),file_size number,script_size number)");
                    prepareStatement.addBatch("CREATE TABLE object_dependency (id number,object_id number,project_id number,dependency_object_id number)");
                    prepareStatement.addBatch("CREATE TABLE object_tag (id number,object_id number,project_id number,type varchar2(100),name varchar2(100),namespace varchar2(100),qName varchar2(100),rawName varchar2(100),prefix varchar2(100),count number,tag_size number)");
                    prepareStatement.addBatch("CREATE SEQUENCE statistics_project_s");
                    prepareStatement.addBatch("CREATE SEQUENCE object_tag_s");
                    prepareStatement.addBatch("CREATE SEQUENCE object_dependency_s");
                    prepareStatement.executeBatch();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (prepareStatement == null) break block12;
                    try {
                        prepareStatement.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (prepareStatement != null) {
                    try {
                        prepareStatement.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Status saveAll(Connection connection) {
        if (StatisticsProject.NONE_PROJECT.equals(this.project)) {
            Status warning = new Status(0);
            warning.setMessage("\u9700\u8981\u7ed1\u5b9a \u5de5\u7a0b\u540e\u624d\u53ef\u4ee5\u4fdd\u5b58\u7edf\u8ba1\u4fe1\u606f\u3002");
            return warning;
        }
        try {
            try {
                this.setProjectID(connection);
                int maxObjectID = this.getMaxObjectID(connection);
                this.saveObjects(this.BATCH_SIZE, connection, maxObjectID);
                this.saveTags(this.BATCH_SIZE, connection);
                this.saveDependencies(connection);
            }
            catch (SQLException e) {
                Status es = new Status(1);
                es.setMessage(e.getMessage());
                e.printStackTrace();
                Status status = es;
                try {
                    connection.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return status;
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }

    private int getMaxObjectID(Connection connection) throws SQLException {
        String selectMaxObjectID = "SELECT max(id) max from project_object ";
        PreparedStatement prepareStatement = null;
        try {
            int maxObjectID;
            prepareStatement = connection.prepareStatement(selectMaxObjectID);
            ResultSet executeQuery = prepareStatement.executeQuery();
            executeQuery.next();
            int n = maxObjectID = executeQuery.getInt(1);
            return n;
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setProjectID(Connection connection) throws SQLException {
        PreparedStatement prepareStatement = null;
        try {
            prepareStatement = connection.prepareStatement("SELECT statistics_project_s.nextval from dual ");
            ResultSet executeQuery = prepareStatement.executeQuery();
            executeQuery.next();
            int projectID = executeQuery.getInt(1);
            this.project.setProjectId(String.valueOf(projectID));
            this.saveProject(connection);
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public StatisticsResult readAll(Connection connection) {
        this.result = new StatisticsResult();
        this.poMap = new HashMap<Integer, ProjectObject>();
        this.result.setProject(this.project);
        this.readProjectObject(connection);
        this.readAllTag(connection);
        this.readAllDependecies(connection);
        for (List<String> list : this.reference.values()) {
            for (String s : list) {
                this.referenced.put(s, this.referenced.get(s) == null ? 1 : this.referenced.get(s) + 1);
            }
        }
        for (ProjectObject po : this.result.getProjectObjects()) {
            if (this.referenced.get(po.getObjectId()) == null) continue;
            po.setReferenced(this.referenced.get(po.getObjectId()));
        }
        return this.result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAllDependecies(Connection connection) {
        String pid = this.project.getProjectId();
        PreparedStatement prepareStatement = null;
        try {
            try {
                prepareStatement = connection.prepareStatement("SELECT * FROM object_dependency WHERE project_id = ?");
                prepareStatement.setInt(1, Integer.valueOf(pid));
                ResultSet rs = prepareStatement.executeQuery();
                boolean index = false;
                while (rs.next()) {
                    int dID = rs.getInt(1);
                    int objectID = rs.getInt(2);
                    int projectID = rs.getInt(3);
                    int dependencyObjectID = rs.getInt(4);
                    Dependency d = new Dependency();
                    d.setDependencyID(String.valueOf(dID));
                    d.setProjectId(String.valueOf(projectID));
                    ProjectObject po = this.poMap.get(objectID);
                    po.addDependency(d);
                    d.setDependencyObject(this.poMap.get(dependencyObjectID));
                    d.setObject(po);
                    d.setProject(this.project);
                    if (this.reference.get(po.getObjectId()) == null) {
                        this.reference.put(po.getObjectId(), new ArrayList());
                    }
                    this.reference.get(po.getObjectId()).add(d.getDependencyObject().getObjectId());
                }
                return;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                if (prepareStatement == null) return;
                try {
                    prepareStatement.close();
                    return;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (prepareStatement == null) return;
                try {
                    prepareStatement.close();
                    return;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAllTag(Connection connection) {
        String pid = this.project.getProjectId();
        PreparedStatement prepareStatement = null;
        try {
            try {
                prepareStatement = connection.prepareStatement("SELECT * FROM object_tag WHERE project_id = ? ");
                prepareStatement.setInt(1, Integer.valueOf(pid));
                ResultSet rs = prepareStatement.executeQuery();
                boolean index = false;
                while (rs.next()) {
                    int tagID = rs.getInt(1);
                    int objectID = rs.getInt(2);
                    int projectID = rs.getInt(3);
                    String type = rs.getString(4);
                    String name = rs.getString(5);
                    String namespace = rs.getString(6);
                    String qName = rs.getString(7);
                    String rawName = rs.getString(8);
                    String prefix = rs.getString(9);
                    int count = rs.getInt(10);
                    int tagSize = rs.getInt(11);
                    Tag t = new Tag();
                    t.setCount(count);
                    t.setName(name == null ? "" : name);
                    t.setNamespace(namespace == null ? "" : namespace);
                    t.setObjectId(String.valueOf(objectID));
                    t.setPrefix(prefix == null ? "" : prefix);
                    t.setProjectId(String.valueOf(projectID));
                    t.setqName(qName == null ? "" : qName);
                    t.setRawName(rawName == null ? "" : rawName);
                    t.setSize(tagSize);
                    t.setTagId(String.valueOf(tagID));
                    t.setType(type == null ? "" : type);
                    ProjectObject po = this.poMap.get(objectID);
                    t.setObject(po);
                    t.setProject(this.project);
                    po.addTag(t);
                }
                return;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                if (prepareStatement == null) return;
                try {
                    prepareStatement.close();
                    return;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (prepareStatement == null) return;
                try {
                    prepareStatement.close();
                    return;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readProjectObject(Connection connection) {
        String pid = this.project.getProjectId();
        PreparedStatement prepareStatement = null;
        try {
            try {
                prepareStatement = connection.prepareStatement("SELECT * FROM project_object WHERE project_id = ? ");
                prepareStatement.setInt(1, Integer.valueOf(pid));
                ResultSet rs = prepareStatement.executeQuery();
                boolean index = false;
                while (rs.next()) {
                    int objectID = rs.getInt(1);
                    int projectID = rs.getInt(2);
                    String type = rs.getString(3);
                    String name = rs.getString(4);
                    String path = rs.getString(5);
                    int fileSize = rs.getInt(6);
                    int scriptSize = rs.getInt(7);
                    ProjectObject po = new ProjectObject();
                    po.setFileSize(fileSize);
                    po.setName(name);
                    po.setObjectId(String.valueOf(objectID));
                    po.setPath(path);
                    po.setProjectId(String.valueOf(projectID));
                    po.setScriptSize(scriptSize);
                    po.setType(type);
                    po.setProject(this.project);
                    this.result.addProjectObject(po);
                    this.poMap.put(objectID, po);
                }
                return;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                if (prepareStatement == null) return;
                try {
                    prepareStatement.close();
                    return;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (prepareStatement == null) return;
                try {
                    prepareStatement.close();
                    return;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (prepareStatement != null) {
                try {
                    prepareStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

