/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.DashboardConfig;
import java.io.IOException;
import java.util.Map;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class Dashboard
extends Component {
    public static final String VERSION = "$Revision: 7794 $";

    public Dashboard(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected int getDefaultWidth() {
        return 300;
    }

    @Override
    protected int getDefaultHeight() {
        return 300;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addJavaScript(session, context, "graphic/Graphics-min.js");
        this.addJavaScript(session, context, "dashboard/Dashboard-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        DashboardConfig dc = DashboardConfig.getInstance(view);
        JSONObject chart = dc.getChart();
        JSONObject board = dc.getBoard();
        JSONObject pointer = dc.getPointer();
        JSONObject title = dc.getTitle();
        this.addConfig("chart", chart);
        if (board != null) {
            this.addConfig("board", board);
        }
        if (pointer != null) {
            this.addConfig("pointer", pointer);
        }
        if (title != null) {
            this.addConfig("title", title);
        }
        map.put("config", this.getConfigString());
    }
}

