/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.FieldConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class Field
extends Component {
    public static final String VERSION = "$Revision: 7904 $";
    protected static final String CLASSNAME_WRAP = "item-wrap";
    protected static final String CLASSNAME_NOTBLANK = "item-notBlank";
    protected static final String CLASSNAME_READONLY = "item-readOnly";
    private String CONFIG_CONTEXT = "context";

    public Field(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        boolean readOnly;
        CompositeMap view = context.getView();
        FieldConfig fc = new FieldConfig();
        fc.initialize(view);
        boolean notBlank = fc.getRequired();
        String wrapClass = CLASSNAME_WRAP;
        if (notBlank) {
            wrapClass = String.valueOf(wrapClass) + " item-notBlank";
        }
        if (readOnly = fc.getReadonly()) {
            wrapClass = String.valueOf(wrapClass) + " item-readOnly";
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        boolean readOnly;
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        FieldConfig fc = new FieldConfig();
        fc.initialize(view);
        if (session.getContextPath() != null) {
            this.addConfig(this.CONFIG_CONTEXT, String.valueOf(session.getContextPath()) + "/");
        }
        boolean notBlank = fc.getRequired();
        map.put("required", notBlank);
        this.addConfig("required", notBlank);
        String renderer = fc.getRenderer();
        if (renderer != null) {
            this.addConfig("renderer", renderer);
        }
        if (readOnly = fc.getReadonly()) {
            map.put("readonly", "readonly");
        }
        this.addConfig("readonly", readOnly);
    }
}

