/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.TextField;
import aurora.presentation.component.std.config.NumberFieldConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class NumberField
extends TextField {
    public static final String VERSION = "$Revision: 7968 $";

    public NumberField(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap model = context.getModel();
        CompositeMap view = context.getView();
        NumberFieldConfig nfc = NumberFieldConfig.getInstance(view);
        if (!nfc.isAllowDecimals()) {
            this.addConfig("allowdecimals", new Boolean(false));
        }
        if (!nfc.isAllowNegative()) {
            this.addConfig("allownegative", new Boolean(false));
        }
        if (!nfc.isAllowFormat()) {
            this.addConfig("allowformat", new Boolean(false));
        }
        if (!nfc.isAllowPad()) {
            this.addConfig("allowpad", new Boolean(false));
        }
        if (nfc.getMin() != null) {
            this.addConfig("min", TextParser.parse((String)nfc.getMin(), (CompositeMap)model));
        }
        if (nfc.getMax() != null) {
            this.addConfig("max", TextParser.parse((String)nfc.getMax(), (CompositeMap)model));
        }
        this.addConfig("decimalprecision", new Integer(nfc.getDecimalPrecision(model)));
        Map map = context.getMap();
        map.put(INPUT_TYPE, DEFAULT_INPUT_TYPE);
        map.put("config", this.getConfigString());
    }
}

