/*
 * Decompiled with CFR 0.152.
 */
package aurora.service;

import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.event.RuntimeContext;

public class ServiceContext
extends RuntimeContext {
    public static final String KEY_PARAMETER = "parameter";
    public static final String KEY_SESSION = "session";
    public static final String KEY_RESULT = "result";
    public static final String KEY_ERROR = "error";
    public static final String KEY_MODEL = "model";
    public static final String KEY_CURRENT_PARAMETER = "current_parameter";
    public static final String KEY_PARAMETER_PARSED = "__parameter_parsed__";
    public static final String KEY_SERVICE_NAME = "__service_name__";
    public static final String KEY_ERROR_DESCRIPTION = "__error_description__";
    public static final String KEY_REQUEST_TYPE = "__request_type__";

    public static ServiceContext createServiceContext(CompositeMap map) {
        ServiceContext context = new ServiceContext();
        context.initialize(map);
        return context;
    }

    protected CompositeMap getChildSection(String name) {
        CompositeMap result = this.object_context.getChild(name);
        if (result == null) {
            result = this.object_context.createChild(name);
        }
        return result;
    }

    public CompositeMap getParameter() {
        return this.getChildSection(KEY_PARAMETER);
    }

    public void setParameter(CompositeMap param) {
        this.getParameter().copy(param);
    }

    public void setParameters(Map param) {
        CompositeMap p = this.getParameter();
        p.clear();
        if (param instanceof CompositeMap) {
            this.setParameter((CompositeMap)param);
        } else {
            p.putAll(param);
        }
    }

    public List getParameterList() {
        CompositeMap param = this.getParameter();
        return param.getChilds();
    }

    public CompositeMap getSession() {
        return this.getChildSection(KEY_SESSION);
    }

    public CompositeMap getResult() {
        return this.getChildSection(KEY_RESULT);
    }

    public CompositeMap getError() {
        return this.getChildSection(KEY_ERROR);
    }

    public boolean hasError() {
        CompositeMap error = this.getObjectContext().getChild(KEY_ERROR);
        return error != null;
    }

    public CompositeMap getModel() {
        return this.getChildSection(KEY_MODEL);
    }

    public void setError(CompositeMap error) {
        CompositeMap map = this.getObjectContext();
        error.setName(KEY_ERROR);
        CompositeMap old_error = map.getChild(KEY_ERROR);
        if (old_error != null) {
            map.removeChild(old_error);
        }
        map.addChild(error);
    }

    public String getServiceName() {
        return this.getString(KEY_SERVICE_NAME);
    }

    public void setServiceName(String service_name) {
        this.put(KEY_SERVICE_NAME, service_name);
    }

    public CompositeMap getCurrentParameter() {
        CompositeMap map = (CompositeMap)this.get(KEY_CURRENT_PARAMETER);
        if (map == null) {
            map = this.getParameter();
        }
        return map;
    }

    public void setCurrentParameter(Map param) {
        if (param == null) {
            this.getObjectContext().remove((Object)KEY_CURRENT_PARAMETER);
            return;
        }
        CompositeMap p = null;
        if (param instanceof CompositeMap) {
            p = (CompositeMap)param;
        } else {
            p = new CompositeMap("current-parameter");
            p.putAll(param);
            p.setParent(this.getObjectContext());
        }
        CompositeMap parent = p.getParent();
        this.put(KEY_CURRENT_PARAMETER, p);
        p.setParent(parent);
    }

    public String getRequestType() {
        return this.getString(KEY_REQUEST_TYPE);
    }

    public void setRequestType(String type) {
        this.putString(KEY_REQUEST_TYPE, type);
    }
}

