/*
 * Decompiled with CFR 0.152.
 */
package aurora.service;

import aurora.database.service.SqlServiceContext;
import aurora.service.IConfigurableService;
import aurora.service.IResourceReleaser;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceController;
import aurora.service.ServiceOutputConfig;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.Configuration;
import uncertain.event.IEventDispatcher;
import uncertain.event.RuntimeContext;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class ServiceInstance
implements IService,
IConfigurableService {
    public static final String KEY_SERVICE_NAME = "service_name";
    public static final String LOGGING_TOPIC = "aurora.application";
    protected IProcedureManager mProcManager;
    boolean mContextInited = false;
    boolean mConfigParsed = false;
    protected CompositeMap mContextMap;
    protected ServiceContext mServiceContext;
    protected ServiceController mController;
    protected Configuration mRootConfig;
    protected Configuration mConfig;
    protected CompositeMap mConfigMap;
    protected ProcedureRunner mRunner;
    private Object[] mEventArgs = new Object[]{this};
    protected List<IResourceReleaser> mResourceReleasers = new LinkedList<IResourceReleaser>();
    static final String INSTANCE_KEY = RuntimeContext.getTypeKey(IService.class);

    public static ServiceInstance getInstance(CompositeMap context) {
        return (ServiceInstance)context.get((Object)INSTANCE_KEY);
    }

    public static void setInstance(CompositeMap context, IService inst) {
        context.put((Object)INSTANCE_KEY, (Object)inst);
    }

    public ServiceInstance(String name, IProcedureManager proc_manager) {
        this.mProcManager = proc_manager;
        CompositeMap context = new CompositeMap("context");
        this.setContextMap(context);
        this.setName(name);
        this.mConfig = this.mProcManager.createConfig();
    }

    @Override
    public void parseConfig() {
        if (this.mConfig != null) {
            this.mConfig.clear();
        }
        if (this.mRootConfig != null) {
            try {
                this.mRootConfig.fireEvent("PrepareServiceConfig", this.mEventArgs);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in event PopulateServiceConfig", ex);
            }
        }
        this.mConfig = this.mProcManager.createConfig();
        this.mConfig.addParticipant((Object)this);
        this.mConfig.loadConfig(this.mConfigMap);
        if (this.mRootConfig != null) {
            this.mConfig.setParent(this.mRootConfig);
        }
        this.mConfigParsed = true;
    }

    void initContext() {
        if (!this.mContextInited) {
            this.mProcManager.initContext(this.mContextMap);
            this.mContextInited = true;
        }
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.mServiceContext;
    }

    @Override
    public void setServiceContext(ServiceContext context) {
        this.mServiceContext = context;
    }

    void initProcedureRunner(Procedure proc) {
        this.mRunner = new ProcedureRunner();
        this.mRunner.setProcedure(proc);
        this.mRunner.setContext(this.mContextMap);
        this.mRunner.setConfiguration(this.mConfig);
    }

    @Override
    public boolean invoke(Procedure proc) throws Exception {
        this.initContext();
        this.initProcedureRunner(proc);
        this.mRunner.run();
        if (this.mRunner.getException() != null) {
            this.mServiceContext.setSuccess(false);
            throw new RuntimeException(this.mRunner.getException());
        }
        return this.mServiceContext.isSuccess();
    }

    public CompositeMap getContextMap() {
        return this.mContextMap;
    }

    @Override
    public IEventDispatcher getConfig() {
        return this.mConfig;
    }

    public void setContextMap(CompositeMap contextMap) {
        this.mContextMap = contextMap;
        this.mServiceContext = (ServiceContext)((Object)DynamicObject.cast((CompositeMap)contextMap, ServiceContext.class));
        this.mController = ServiceController.createServiceController(this.mContextMap);
        this.mServiceContext.setInstanceOfType(IService.class, this);
    }

    @Override
    public CompositeMap getServiceConfigData() {
        return this.mConfigMap;
    }

    public void setServiceConfigData(CompositeMap configMap) {
        this.setServiceConfigData(configMap, true);
    }

    @Override
    public void setServiceConfigData(CompositeMap configMap, boolean parse) {
        this.mConfigMap = configMap;
        if (parse) {
            this.parseConfig();
        }
    }

    public void setName(String name) {
        this.mContextMap.put((Object)KEY_SERVICE_NAME, (Object)name);
    }

    public String getName() {
        return this.mContextMap.getString((Object)KEY_SERVICE_NAME);
    }

    public Configuration getServiceConfig() {
        return this.mConfig;
    }

    protected void clearMap(CompositeMap data) {
        if (data != null) {
            data.clear();
        }
    }

    public boolean isTraceOn() {
        if (this.mConfigMap == null) {
            return true;
        }
        return this.mConfigMap.getBoolean((Object)"trace", false);
    }

    @Override
    public boolean isConfigParsed() {
        return this.mConfigParsed;
    }

    public void clear() {
        SqlServiceContext sqlServiceContext = (SqlServiceContext)((Object)this.mServiceContext.castTo(SqlServiceContext.class));
        try {
            try {
                sqlServiceContext.freeConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException("freeConnection failed", e);
            }
        }
        finally {
            this.mProcManager.destroyContext(this.mContextMap);
            this.clearMap(this.mContextMap);
            this.clearMap(this.mConfigMap);
            if (this.mConfig != null) {
                this.mConfig.clear();
            }
        }
    }

    public ServiceController getController() {
        return this.mController;
    }

    public ServiceOutputConfig getServiceOutputConfig() {
        CompositeMap child;
        CompositeMap compositeMap = child = this.mConfigMap == null ? null : this.mConfigMap.getChild("service-output");
        if (child == null) {
            return null;
        }
        return ServiceOutputConfig.getInstance(child);
    }

    public Configuration getRootConfig() {
        return this.mRootConfig;
    }

    public void setRootConfig(Configuration rootConfig) {
        this.mRootConfig = rootConfig;
        this.mConfig.setParent(this.mRootConfig);
    }

    public ILogger getServiceLogger() {
        return LoggingContext.getLogger((CompositeMap)this.mContextMap, (String)LOGGING_TOPIC);
    }

    @Override
    public void release() {
        if (this.mResourceReleasers.size() > 0) {
            for (IResourceReleaser rl : this.mResourceReleasers) {
                try {
                    rl.doRelease(this.mServiceContext);
                }
                catch (Throwable thr) {
                    this.mRunner.getLogger().log(Level.WARNING, "Error when releasing resource", thr);
                }
            }
        }
    }

    @Override
    public void addResourceReleaser(IResourceReleaser rl) {
        this.mResourceReleasers.add(rl);
    }
}

