/*
 * Decompiled with CFR 0.152.
 */
package uncertain.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import uncertain.event.IEventHandle;
import uncertain.event.IEventListener;
import uncertain.event.ISingleEventHandle;
import uncertain.event.ReflectionMethodHandle;
import uncertain.proc.ParticipantRegistry;

public class HandleManager
implements Cloneable {
    ParticipantRegistry registry;
    HashMap event_handle_map;
    LinkedList listener_list;
    HashSet participants_set;

    public HandleManager() {
        this.registry = ParticipantRegistry.defaultInstance();
        this.event_handle_map = new HashMap();
    }

    public HandleManager(ParticipantRegistry m) {
        this.registry = m;
        this.event_handle_map = new HashMap();
    }

    private List[] createHandleList() {
        List[] lst = new List[3];
        return lst;
    }

    private void addHandle(List[] handle_list, int sequence, IEventHandle handle, boolean add_to_first) {
        LinkedList<IEventHandle> l = handle_list[sequence];
        if (l == null) {
            handle_list[sequence] = l = new LinkedList<IEventHandle>();
        }
        if (add_to_first) {
            l.add(0, handle);
        } else {
            l.add(handle);
        }
    }

    public void addEventHandle(String event_name, int sequence, IEventHandle handle, boolean add_to_first) {
        if (sequence < 0 || sequence > 2) {
            throw new IllegalArgumentException("sequence must be one of the following values: EventModel.PRE_EVENT , EventModel.ON_EVENT , EventModel.POST_EVENT");
        }
        List[] handle_list = (List[])this.event_handle_map.get(event_name = event_name.toLowerCase());
        if (handle_list == null) {
            handle_list = this.createHandleList();
            this.event_handle_map.put(event_name, handle_list);
        }
        this.addHandle(handle_list, sequence, handle, add_to_first);
    }

    public void addEventHandle(String event_name, int sequence, IEventHandle handle) {
        this.addEventHandle(event_name, sequence, handle, true);
    }

    public List getEventHandleList(String event_name, int sequence) {
        if (sequence < 0 || sequence > 2) {
            throw new IllegalArgumentException("sequence must be one of the following values: EventModel.PRE_EVENT , EventModel.ON_EVENT , EventModel.POST_EVENT");
        }
        List[] handle_list = (List[])this.event_handle_map.get(event_name = event_name.toLowerCase());
        if (handle_list == null) {
            return null;
        }
        return handle_list[sequence];
    }

    public ListIterator getEventHandleIterator(String event_name, int sequence) {
        List l = this.getEventHandleList(event_name, sequence);
        if (l == null) {
            return null;
        }
        return l.listIterator();
    }

    public ListIterator getEventListenerIterator() {
        if (this.listener_list != null) {
            return this.listener_list.listIterator();
        }
        return null;
    }

    public void addParticipant(Object participant, boolean add_to_first) {
        if (this.participants_set == null) {
            this.participants_set = new HashSet();
        }
        this.participants_set.add(participant);
        if (participant instanceof IEventListener) {
            if (this.listener_list == null) {
                this.listener_list = new LinkedList();
            }
            if (add_to_first) {
                this.listener_list.addFirst(participant);
            } else {
                this.listener_list.add(participant);
            }
        }
        int i = 0;
        Class<?> cls = participant.getClass();
        ParticipantRegistry.HandleMethod[] methods = this.registry.getHandleMethods(cls);
        i = 0;
        while (i < methods.length) {
            ParticipantRegistry.HandleMethod hm = methods[i];
            ReflectionMethodHandle handle = new ReflectionMethodHandle(participant, hm.method, hm.arg_type);
            this.addEventHandle(hm.event_name, hm.sequence, handle, add_to_first);
            ++i;
        }
    }

    public void addParticipant(Object participant) {
        this.addParticipant(participant, true);
    }

    public Set getParticipants() {
        if (this.participants_set == null) {
            return null;
        }
        return this.participants_set;
    }

    public Map getHandleMap() {
        return this.event_handle_map;
    }

    public Object clone() {
        HandleManager manager = new HandleManager(this.registry);
        manager.event_handle_map.putAll(this.event_handle_map);
        if (this.listener_list != null) {
            manager.listener_list = new LinkedList();
            manager.listener_list.addAll(this.listener_list);
        }
        if (this.participants_set != null) {
            manager.participants_set = new HashSet();
            manager.participants_set.addAll(this.participants_set);
        }
        return manager;
    }

    public void addSingleEventHandle(ISingleEventHandle handle, boolean add_to_first) {
        this.addEventHandle(handle.getEvent(), handle.getHandleSequence(), handle, add_to_first);
    }

    public void addSingleEventHandle(ISingleEventHandle handle) {
        this.addSingleEventHandle(handle, true);
    }

    public void clear() {
        if (this.event_handle_map != null) {
            this.event_handle_map.clear();
        }
        if (this.listener_list != null) {
            this.listener_list.clear();
        }
        if (this.participants_set != null) {
            this.participants_set.clear();
        }
    }
}

