/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.util.HashMap;
import java.util.Map;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.IPerObjectLoggingConfig;

public class DefaultPerObjectLoggingConfig
implements IPerObjectLoggingConfig {
    Map mConfigMap = new HashMap();
    boolean enabledAll = false;

    private String getTraceFlagKey(String object_name) {
        return String.valueOf(object_name) + ".trace";
    }

    private String getLoggerProviderKey(String object_name) {
        return String.valueOf(object_name) + ".logger_provider";
    }

    @Override
    public boolean getTraceFlag(String object_name) {
        if (this.enabledAll) {
            return true;
        }
        Boolean trace = (Boolean)this.mConfigMap.get(this.getTraceFlagKey(object_name));
        return trace == null ? false : trace;
    }

    @Override
    public void setTraceFlag(String object_name, boolean flag) {
        this.mConfigMap.put(this.getTraceFlagKey(object_name), new Boolean(flag));
    }

    @Override
    public ILoggerProvider getLoggerProvider(String object_name) {
        ILoggerProvider provider = (ILoggerProvider)this.mConfigMap.get(this.getLoggerProviderKey(object_name));
        return provider;
    }

    @Override
    public void setLoggerProvider(String object_name, ILoggerProvider provider) {
        this.mConfigMap.put(this.getLoggerProviderKey(object_name), object_name);
    }

    @Override
    public void clearSettings() {
        this.mConfigMap.clear();
    }

    public boolean isEnabledAll() {
        return this.enabledAll;
    }

    public void setEnabledAll(boolean enabledAll) {
        this.enabledAll = enabledAll;
    }
}

