/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import uncertain.event.IContextListener;
import uncertain.event.RuntimeContext;
import uncertain.logging.AbstractLoggerProvider;
import uncertain.logging.BasicConsoleHandler;
import uncertain.logging.BasicStreamHandler;
import uncertain.logging.DefaultFormatter;
import uncertain.logging.DefaultLogger;
import uncertain.logging.ILogPathSettable;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.LoggingTopic;
import uncertain.logging.TopicManager;

public class LoggerProvider
extends AbstractLoggerProvider
implements ILogPathSettable,
IContextListener {
    static final DefaultFormatter DEFAULT_FORMATTER = new DefaultFormatter();
    TopicManager mTopicManager;
    Handler[] mHandlers;
    Level mDefaultLevel = Level.WARNING;
    Formatter mFormatter = DEFAULT_FORMATTER;
    String mName;
    String mLogPath;
    Map mDefaultLoggerMap = new HashMap();

    public static LoggerProvider createInstance() {
        LoggerProvider provider = new LoggerProvider();
        provider.addHandles(new Handler[]{new BasicConsoleHandler()});
        return provider;
    }

    public static LoggerProvider createInstance(Level level, OutputStream log_output) {
        LoggerProvider provider = new LoggerProvider();
        provider.setDefaultLogLevel(level.toString());
        BasicStreamHandler handler = new BasicStreamHandler(log_output);
        provider.addHandle(handler);
        return provider;
    }

    public static LoggerProvider createInstance(String topic, Level level) {
        LoggerProvider provider = LoggerProvider.createInstance();
        provider.getTopicManager().setTopicLevel(topic, level);
        return provider;
    }

    public LoggerProvider() {
        this.mTopicManager = new TopicManager();
    }

    public LoggerProvider(TopicManager topic_manager) {
        this.mTopicManager = topic_manager;
    }

    public void addTopics(LoggingTopic[] topics) {
        this.mTopicManager.setTopicLevel(topics);
    }

    public void addHandles(Handler[] handles) {
        this.mHandlers = handles;
        int i = 0;
        while (i < this.mHandlers.length) {
            Handler h = this.mHandlers[i];
            h.setFormatter(this.mFormatter);
            if (h instanceof ILogPathSettable && this.mLogPath != null) {
                ((ILogPathSettable)((Object)h)).setLogPath(this.mLogPath);
            }
            ++i;
        }
    }

    public void addHandle(Handler handler) {
        this.addHandles(new Handler[]{handler});
    }

    public Handler[] getHandlers() {
        return this.mHandlers;
    }

    protected ILogger getDefaultLogger(String topic) {
        ILogger logger = (ILogger)this.mDefaultLoggerMap.get(topic);
        if (logger == null) {
            logger = this.createEmptyLogger(topic);
            logger.setLevel(this.mDefaultLevel);
            this.mDefaultLoggerMap.put(topic, logger);
        }
        return logger;
    }

    @Override
    public ILogger getLogger(String topic) {
        if (this.mTopicManager.isLoggingEnabled(topic)) {
            ILogger logger = this.createEmptyLogger(topic);
            logger.setLevel(this.mTopicManager.getTopicLevel(topic));
            return logger;
        }
        return this.getDefaultLogger(topic);
    }

    protected ILogger createEmptyLogger(String topic) {
        DefaultLogger logger = new DefaultLogger(topic);
        if (this.mHandlers != null) {
            int i = 0;
            while (i < this.mHandlers.length) {
                logger.addHandler(this.mHandlers[i]);
                ++i;
            }
        }
        return logger;
    }

    public TopicManager getTopicManager() {
        return this.mTopicManager;
    }

    public void setTopicManager(TopicManager m) {
        this.mTopicManager = m;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getLogPath() {
        return this.mLogPath;
    }

    @Override
    public void setLogPath(String logPath) {
        this.mLogPath = logPath;
    }

    public String getDefaultLogLevel() {
        return this.mDefaultLevel.toString();
    }

    public void setDefaultLogLevel(String defaultLogLevel) {
        this.mDefaultLevel = Level.parse(defaultLogLevel);
    }

    public void initializeContext(RuntimeContext context) {
        ILoggerProvider lp = (ILoggerProvider)context.getInstanceOfType(ILoggerProvider.class);
        if (lp != null) {
            ILoggerProvider p = this.joinTogether(lp);
            context.setInstanceOfType(ILoggerProvider.class, p);
        } else {
            context.setInstanceOfType(ILoggerProvider.class, this);
        }
    }

    @Override
    public void onContextCreate(RuntimeContext context) {
        this.initializeContext(context);
    }

    @Override
    public void onContextDestroy(RuntimeContext context) {
    }
}

