/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.util.Collection;
import java.util.Collections;
import uncertain.event.IContextListener;
import uncertain.event.RuntimeContext;
import uncertain.logging.ILogPathSettable;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.logging.ILoggerProviderGroup;
import uncertain.logging.LoggerProviderGroup;
import uncertain.ocm.IObjectRegistry;

public class LoggingConfig
implements ILoggerProvider,
IContextListener,
ILogPathSettable {
    public static final String LOGGING_REGISTRY_PATH = "uncertain.logging.DefaultRegistry";
    LoggerProviderGroup mLoggerProviderGroup = new LoggerProviderGroup();
    IObjectRegistry mObjectRegistry;
    String mLogPath;

    public LoggingConfig() {
    }

    public LoggingConfig(IObjectRegistry reg) {
        this();
        this.mObjectRegistry = reg;
    }

    @Override
    public ILogger getLogger(String topic) {
        return this.mLoggerProviderGroup.getLogger(topic);
    }

    public void addProviders(ILoggerProvider[] providers) {
        int i = 0;
        while (i < providers.length) {
            this.mLoggerProviderGroup.addLoggerProvider(providers[i]);
            ++i;
        }
    }

    public ILoggerProvider joinTogether(ILoggerProvider existing_provider) {
        if (existing_provider == null) {
            return this;
        }
        if (existing_provider instanceof ILoggerProviderGroup) {
            ((ILoggerProviderGroup)((Object)existing_provider)).addLoggerProvider(this);
            return existing_provider;
        }
        LoggerProviderGroup group = new LoggerProviderGroup();
        group.addLoggerProvider(this);
        group.addLoggerProvider(existing_provider);
        return group;
    }

    public void initializeContext(RuntimeContext context) {
        ILoggerProvider lp = (ILoggerProvider)context.getInstanceOfType(ILoggerProvider.class);
        if (lp != null) {
            ILoggerProvider p = this.joinTogether(lp);
            context.setInstanceOfType(ILoggerProvider.class, p);
        } else {
            context.setInstanceOfType(ILoggerProvider.class, this);
        }
    }

    @Override
    public void onContextCreate(RuntimeContext context) {
        this.initializeContext(context);
    }

    @Override
    public void onContextDestroy(RuntimeContext context) {
    }

    public void onInitialize() {
        this.registerTo(this.mObjectRegistry);
    }

    public void registerTo(IObjectRegistry os) {
        ILoggerProvider existing_provider = (ILoggerProvider)os.getInstanceOfType(ILoggerProvider.class);
        if (existing_provider == null) {
            os.registerInstance(ILoggerProvider.class, this);
        } else {
            ILoggerProvider p = this.joinTogether(existing_provider);
            os.registerInstance(ILoggerProvider.class, p);
        }
    }

    public Collection getLoggerProviders() {
        return Collections.unmodifiableCollection(this.mLoggerProviderGroup.mProviderSet);
    }

    @Override
    public String getLogPath() {
        return this.mLogPath;
    }

    @Override
    public void setLogPath(String logPath) {
        this.mLogPath = logPath;
        for (ILoggerProvider provider : this.mLoggerProviderGroup.mProviderSet) {
            if (!(provider instanceof ILogPathSettable)) continue;
            ((ILogPathSettable)((Object)provider)).setLogPath(logPath);
        }
    }
}

