/*
 * Decompiled with CFR 0.152.
 */
package uncertain.pkg;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import uncertain.composite.CompositeLoader;
import uncertain.core.DirectoryConfig;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.pkg.ComponentPackage;
import uncertain.pkg.ConfigurableInstance;
import uncertain.pkg.IInstanceCreationListener;

public class InstanceConfig
extends AbstractLocatableObject {
    ConfigurableInstance[] mInstances;
    ComponentPackage mOwnerPackage;
    IObjectRegistry mObjRegistry;
    DirectoryConfig mDirectoryConfig;
    File mLocalConfigPath;
    boolean mHasLocalConfigPath = false;
    static final ConfigurableInstanceComparator COMPARATOR = new ConfigurableInstanceComparator();

    public InstanceConfig(IObjectRegistry reg) {
        this.mObjRegistry = reg;
        this.mDirectoryConfig = (DirectoryConfig)this.mObjRegistry.getInstanceOfType(DirectoryConfig.class);
        if (this.mDirectoryConfig == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, DirectoryConfig.class);
        }
    }

    public ConfigurableInstance[] getInstances() {
        return this.mInstances;
    }

    public void setInstances(ConfigurableInstance[] instances) {
        this.mInstances = instances;
    }

    public ComponentPackage getOwnerPackage() {
        return this.mOwnerPackage;
    }

    public void setOwnerPackage(ComponentPackage ownerPackage) {
        this.mOwnerPackage = ownerPackage;
        this.mLocalConfigPath = new File(this.mDirectoryConfig.getConfigDirectory(), ownerPackage.getName());
        this.mHasLocalConfigPath = this.mLocalConfigPath.exists();
    }

    private File getConfigFile(ConfigurableInstance inst) {
        String acf;
        File result = null;
        File pkg_path = this.mOwnerPackage.getConfigPath();
        File config_file = new File(pkg_path, inst.getConfigFile());
        if (config_file.exists()) {
            result = config_file;
        }
        if (this.mHasLocalConfigPath && inst.getConfigFile() != null && (config_file = new File(this.mLocalConfigPath, inst.getConfigFile())).exists()) {
            result = config_file;
        }
        if ((acf = inst.getAlternativeConfigFile()) != null && (config_file = new File(acf = this.mDirectoryConfig.translateRealPath(acf))).exists()) {
            result = config_file;
        }
        return result;
    }

    public Collection<ConfigurableInstance> getInstantiatableList() {
        LinkedList<ConfigurableInstance> inst_list = new LinkedList<ConfigurableInstance>();
        if (this.mInstances != null) {
            ConfigurableInstance[] configurableInstanceArray = this.mInstances;
            int n = this.mInstances.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurableInstance inst = configurableInstanceArray[n2];
                File config_file = this.getConfigFile(inst);
                if (config_file != null) {
                    inst.setActualConfigFile(config_file);
                    inst_list.add(inst);
                }
                ++n2;
            }
        }
        return inst_list;
    }

    public static void loadComponents(Collection<InstanceConfig> inst_config_list, IObjectRegistry obj_registry, CompositeLoader composite_loader, OCManager oc_manager, IInstanceCreationListener listener, boolean continueWithException) {
        HashMap<String, ConfigurableInstance> set = new HashMap<String, ConfigurableInstance>();
        LinkedList<ConfigurableInstance> inst_list = new LinkedList<ConfigurableInstance>();
        for (InstanceConfig config : inst_config_list) {
            Collection<ConfigurableInstance> lst = config.getInstantiatableList();
            inst_list.addAll(lst);
        }
        Collections.sort(inst_list, COMPARATOR);
        int created_num = 0;
        while (inst_list.size() > 0) {
            created_num = 0;
            ListIterator it = inst_list.listIterator();
            while (it.hasNext()) {
                ConfigurableInstance inst = (ConfigurableInstance)it.next();
                if (!inst.canCreateInstance(obj_registry)) continue;
                try {
                    ConfigurableInstance ci = (ConfigurableInstance)set.get(inst.getActualConfigFile().getAbsolutePath());
                    if (ci != null) {
                        throw new RuntimeException("duplicated config file:" + inst.getOriginSource() + ", existing from " + ci.getOriginSource());
                    }
                    set.put(inst.getActualConfigFile().getAbsolutePath(), inst);
                    Object instance = inst.createInstance(composite_loader, oc_manager);
                    inst.registerInstance(instance, obj_registry);
                    if (listener != null) {
                        listener.onInstanceCreate(instance, inst.getActualConfigFile());
                    }
                    ++created_num;
                    it.remove();
                }
                catch (Throwable e) {
                    if (continueWithException) continue;
                    throw new RuntimeException(e);
                }
            }
            if (created_num != 0) continue;
            if (continueWithException) break;
            StringBuffer error_list = new StringBuffer();
            for (ConfigurableInstance inst : inst_list) {
                error_list.append(inst.getActualConfigFile().getAbsolutePath()).append(" ");
            }
            throw BuiltinExceptionFactory.createInstanceDependencyNotMeetException(null, error_list.toString());
        }
    }

    public static class ConfigurableInstanceComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int n1 = ((ConfigurableInstance)o1).getRequiredCount();
            int n2 = ((ConfigurableInstance)o2).getRequiredCount();
            return n1 - n2;
        }
    }
}

