/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.lang.reflect.Method;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.Argument;
import uncertain.proc.ProcedureRunner;

public class MethodInvoke
extends AbstractEntry {
    IObjectRegistry mRegistry;
    String methodName;
    String className;
    String instanceType;
    String resultPath;
    private Argument[] arguments;
    private Class[] argumentClasses;
    private Object[] argumentObjects;

    public MethodInvoke(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        if (this.methodName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "methodName");
        }
        if (this.className == null && this.instanceType == null) {
            throw BuiltinExceptionFactory.createOneAttributeMissing(this, "className,instanceType");
        }
        if (this.className != null && this.instanceType != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "className,instanceType");
        }
        this.initArguments(runner.getContext());
        Object instance = null;
        Method method = null;
        if (this.className != null) {
            method = Class.forName(this.className).getMethod(this.methodName, this.argumentClasses);
        } else if (this.instanceType != null) {
            instance = this.getInstanceOfType(this.mRegistry, Class.forName(this.instanceType));
            if (instance == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(this, Class.forName(this.instanceType));
            }
            Class<?> cls = instance.getClass();
            method = cls.getMethod(this.methodName, this.argumentClasses);
        }
        if (method == null) {
            throw new RuntimeException("Can not find method:" + this.methodName + " in " + this.className);
        }
        Object return_value = method.invoke(instance, this.argumentObjects);
        if (this.resultPath != null) {
            runner.getContext().putObject(this.resultPath, return_value, true);
        }
    }

    private void initArguments(CompositeMap context) {
        if (this.arguments == null) {
            return;
        }
        this.argumentClasses = new Class[this.arguments.length];
        this.argumentObjects = new Object[this.arguments.length];
        int i = 0;
        while (i < this.arguments.length) {
            this.arguments[i].onInitialize(context, this.mRegistry);
            this.argumentClasses[i] = this.arguments[i].getClassType();
            this.argumentObjects[i] = this.arguments[i].getObjectValue();
            ++i;
        }
    }

    private Object getInstanceOfType(IObjectRegistry registry, Class type) {
        Object instance = null;
        if (registry == null || type == null) {
            return null;
        }
        instance = registry.getInstanceOfType(type);
        if (instance != null) {
            return instance;
        }
        Class superClass = type.getSuperclass();
        if (superClass != null && (instance = registry.getInstanceOfType(superClass)) != null) {
            return instance;
        }
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                instance = registry.getInstanceOfType(interfaces[i]);
                if (instance != null) {
                    return instance;
                }
                ++i;
            }
        }
        return instance;
    }

    public IObjectRegistry getRegistry() {
        return this.mRegistry;
    }

    public void setRegistry(IObjectRegistry mRegistry) {
        this.mRegistry = mRegistry;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getResultPath() {
        return this.resultPath;
    }

    public void setResultPath(String resultPath) {
        this.resultPath = resultPath;
    }

    public Argument[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Argument[] arguments) {
        this.arguments = arguments;
    }
}

