/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.QualifiedName;
import uncertain.schema.Array;
import uncertain.schema.Attribute;
import uncertain.schema.ComplexType;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.Namespace;
import uncertain.schema.Schema;
import uncertain.schema.SchemaManager;

public class CompositeMapSchemaUtil {
    public static String getContextFullName(CompositeMap context, QualifiedName qn) {
        String text = null;
        String prefix = CompositeMapSchemaUtil.getContextPrefix(context, qn);
        String localName = qn.getLocalName();
        text = prefix != null ? String.valueOf(prefix) + ":" + localName : localName;
        return text;
    }

    public static String getContextPrefix(CompositeMap context, QualifiedName qn) {
        if (qn == null) {
            return null;
        }
        String prefix = CompositeMapSchemaUtil.getContextPrefix(context, qn.getNameSpace());
        if (prefix == null) {
            prefix = qn.getPrefix();
        }
        return prefix;
    }

    public static String getContextPrefix(CompositeMap context, String uri) {
        if (uri == null || context == null) {
            return null;
        }
        Map prefix_mapping = CompositeUtil.getPrefixMapping(context);
        Object uri_ot = prefix_mapping.get(uri);
        if (uri_ot != null) {
            return (String)uri_ot;
        }
        return null;
    }

    public static CompositeMap addElement(ISchemaManager schemaManager, CompositeMap parent, QualifiedName childQN) {
        if (parent == null || childQN == null) {
            return null;
        }
        String prefix = CompositeMapSchemaUtil.getContextPrefix(parent, childQN);
        CompositeMap child = new CompositeMap(prefix, childQN.getNameSpace(), childQN.getLocalName());
        parent.addChild(child);
        CompositeMapSchemaUtil.addArrayNode(schemaManager, parent);
        return child;
    }

    public static boolean addElement(ISchemaManager schemaManager, CompositeMap node, CompositeMap childNode) {
        if (node == null || childNode == null) {
            return false;
        }
        node.addChild(childNode);
        CompositeMapSchemaUtil.addArrayNode(schemaManager, node);
        return true;
    }

    public static void addArrayNode(ISchemaManager schemaManager, CompositeMap parent) {
        Element element = schemaManager.getElement(parent);
        if (element != null && element.isArray()) {
            QualifiedName qName = parent.getQName();
            if (CompositeUtil.findChild(parent.getParent(), qName) == null) {
                parent.getParent().addChild(parent);
            }
        }
    }

    public static void addElementArray(ISchemaManager schemaManager, CompositeMap parentCM) {
        List arrays;
        Element element = schemaManager.getElement(parentCM);
        if (element != null && (arrays = element.getAllArrays()) != null) {
            for (Array array : arrays) {
                String name = array.getLocalName();
                CompositeMap newCM = new CompositeMap(parentCM.getPrefix(), parentCM.getNamespaceURI(), name);
                parentCM.addChild(newCM);
            }
        }
    }

    public static List getAvailableChildElements(ISchemaManager schemaManager, CompositeMap parent) {
        Element element = schemaManager.getElement(parent);
        if (element == null) {
            return null;
        }
        List<Element> childElements = new LinkedList();
        if (element.isArray()) {
            IType type = element.getElementType();
            if (type instanceof Element) {
                Element arrayType = schemaManager.getElement(type.getQName());
                childElements.add(arrayType);
            } else if (type instanceof ComplexType) {
                childElements.addAll(schemaManager.getElementsOfType(type));
            }
        } else {
            childElements = CompositeMapSchemaUtil.getChildElements(schemaManager, parent);
        }
        if (childElements != null) {
            Collections.sort(childElements);
        }
        return childElements;
    }

    private static List getChildElements(ISchemaManager schemaManager, CompositeMap parent) {
        Element element = schemaManager.getElement(parent);
        Set schemaChilds = CompositeMapSchemaUtil.getSchemaChilds(schemaManager, element);
        ArrayList<Element> availableChilds = new ArrayList<Element>();
        if (schemaChilds != null) {
            for (Object object : schemaChilds) {
                if (!(object instanceof Element)) continue;
                Element ele = (Element)object;
                QualifiedName childQN = ele.getQName();
                if (ele.getMaxOccurs() == null) {
                    availableChilds.add(ele);
                    continue;
                }
                int maxOccurs = Integer.valueOf(ele.getMaxOccurs());
                int nowOccurs = CompositeMapSchemaUtil.getCountOfChildElement(parent, childQN);
                if (nowOccurs >= maxOccurs) continue;
                availableChilds.add(ele);
            }
        }
        return availableChilds;
    }

    public static Set getSchemaChilds(ISchemaManager manager, Element element) {
        HashSet<Element> childs = new HashSet<Element>();
        Set childElements = element.getChilds();
        if (childElements == null) {
            return childs;
        }
        Iterator cit = childElements.iterator();
        while (cit != null && cit.hasNext()) {
            Object node = cit.next();
            if (!(node instanceof ComplexType)) continue;
            ComplexType context = (ComplexType)node;
            ComplexType original = manager.getComplexType(context.getQName());
            if (original instanceof Element) {
                Element new_name = (Element)context;
                childs.add(new_name);
                continue;
            }
            childs.addAll(manager.getElementsOfType(original));
        }
        List complexTypes = element.getAllExtendedTypes();
        if (complexTypes == null) {
            return childs;
        }
        Iterator cit2 = complexTypes.iterator();
        while (cit2 != null && cit2.hasNext()) {
            ComplexType ct = (ComplexType)cit2.next();
            if (!(ct instanceof Element)) continue;
            Element new_name = (Element)ct;
            childs.addAll(CompositeMapSchemaUtil.getSchemaChilds(manager, new_name));
        }
        return childs;
    }

    public static int getCountOfChildElement(CompositeMap parent, QualifiedName childQN) {
        List childs = parent.getChildsNotNull();
        int count = 0;
        for (CompositeMap node : childs) {
            if (!node.getQName().equals(childQN)) continue;
            ++count;
        }
        return count;
    }

    public static boolean validNextNodeLegal(ISchemaManager schemaManager, CompositeMap parent, CompositeMap child) {
        if (parent == null || child == null) {
            return false;
        }
        Element parentElement = schemaManager.getElement(parent);
        return CompositeMapSchemaUtil.validNextNodeLegal(schemaManager, parentElement, child.getQName());
    }

    public static boolean validNextNodeLegal(ISchemaManager schemaManager, Element parent, QualifiedName childQN) {
        List arrays;
        QualifiedName array;
        if (parent == null || childQN == null) {
            return false;
        }
        if (parent.isArray() && childQN.equals(array = parent.getElementType().getQName())) {
            return true;
        }
        List childElements = parent.getChildElements(schemaManager);
        if (childElements != null) {
            for (Object object : childElements) {
                Element ele;
                if (!(object instanceof Element) || !childQN.equals((ele = (Element)object).getQName())) continue;
                return true;
            }
        }
        if ((arrays = parent.getAllArrays()) != null) {
            for (Array array2 : arrays) {
                if (!childQN.equals(array2.getQName())) continue;
                return true;
            }
        }
        return false;
    }

    public Set getMaxOcuss(Element element, SchemaManager manager) {
        Element new_name;
        ComplexType ct;
        HashSet<Element> allChildElements = new HashSet<Element>();
        Set childElements = element.getChilds();
        Iterator cit = childElements.iterator();
        while (cit != null && cit.hasNext()) {
            Object node = cit.next();
            if (!(node instanceof ComplexType)) continue;
            ct = (ComplexType)node;
            if (ct instanceof Element) {
                new_name = (Element)ct;
                allChildElements.add(new_name);
                continue;
            }
            allChildElements.addAll(manager.getElementsOfType(ct));
        }
        List complexTypes = element.getAllExtendedTypes();
        if (complexTypes == null) {
            return allChildElements;
        }
        Iterator cit2 = complexTypes.iterator();
        while (cit2 != null && cit2.hasNext()) {
            ct = (ComplexType)cit2.next();
            if (!(ct instanceof Element)) continue;
            new_name = (Element)ct;
            allChildElements.addAll(this.getMaxOcuss(new_name, manager));
        }
        return allChildElements;
    }

    public static Namespace getQualifiedName(CompositeMap root, String prefix) {
        Map namespace_mapping = CompositeUtil.getPrefixMapping(root);
        Schema schema = new Schema();
        Namespace[] ns = CompositeMapSchemaUtil.getNameSpaces(namespace_mapping);
        schema.addNameSpaces(ns);
        Namespace nameSpace = schema.getNamespace(prefix);
        return nameSpace;
    }

    private static Namespace[] getNameSpaces(Map namespaceToPrefix) {
        if (namespaceToPrefix == null) {
            return null;
        }
        Namespace[] namespaces = new Namespace[namespaceToPrefix.keySet().size()];
        Iterator elements = namespaceToPrefix.keySet().iterator();
        int i = 0;
        while (elements.hasNext()) {
            Object element = elements.next();
            Namespace namespace = new Namespace();
            namespace.setPrefix(namespaceToPrefix.get(element).toString());
            namespace.setUrl(element.toString());
            namespaces[i] = namespace;
        }
        return namespaces;
    }

    public static void collectAttribueValues(Set set, String attribueName, CompositeMap root) {
        List childList;
        String attribueValue = root.getString(attribueName);
        if (attribueValue != null) {
            set.add(attribueValue);
        }
        if ((childList = root.getChilds()) != null) {
            for (CompositeMap child : childList) {
                CompositeMapSchemaUtil.collectAttribueValues(set, attribueName, child);
            }
        }
    }

    public static List getArrayAttrs(ISchemaManager schemaManager, CompositeMap arrayData) {
        if (arrayData == null) {
            throw new RuntimeException("CompositeMap data can not be null!");
        }
        Element element = schemaManager.getElement(arrayData);
        if (element == null) {
            throw new RuntimeException("Can't get element schema from " + arrayData.toXML());
        }
        if (!(element instanceof Array)) {
            throw new RuntimeException("Type " + element.getQName() + " is not array");
        }
        Array array = (Array)element;
        IType type = array.getElementType();
        if (type == null) {
            throw new RuntimeException("Can't get array type from " + array.getQName());
        }
        if (!(type instanceof ComplexType)) {
            throw new RuntimeException("Type " + type.getQName() + " is not ComplexType");
        }
        ComplexType type_element = (ComplexType)type;
        List attrib_list = type_element.getAllAttributes();
        return attrib_list;
    }

    public static String[] getArrayAttrNames(ISchemaManager schemaManager, CompositeMap arrayData) {
        List attrib_list = CompositeMapSchemaUtil.getArrayAttrs(schemaManager, arrayData);
        if (attrib_list == null) {
            return null;
        }
        String[] column_index = new String[attrib_list.size()];
        int id = 0;
        for (Attribute attrib : attrib_list) {
            column_index[id++] = attrib.getLocalName();
        }
        return column_index;
    }
}

