/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import uncertain.util.TagParseHandle;
import uncertain.util.TagProcessor;
import uncertain.util.UnixShellTagProcessor;

public class QuickTagParser {
    TagProcessor processor;

    public QuickTagParser(TagProcessor processor) {
        this.processor = processor;
    }

    public QuickTagParser() {
        this.processor = new UnixShellTagProcessor();
    }

    void appendParsedTag(int index, TagProcessor processor, StringBuffer buf, TagParseHandle handle) {
        String str = null;
        String tag = processor.getTagString();
        if (tag != null && tag.length() > 0) {
            str = handle.ProcessTag(index, tag);
        }
        if (str != null) {
            buf.append(str);
        }
    }

    void appendNormalChar(int index, TagParseHandle handle, StringBuffer buf, char ch) {
        int n = handle.ProcessCharacter(index, ch);
        if (n >= 0) {
            buf.append((char)n);
        }
    }

    void appendNormalStrings(int index, TagParseHandle handle, StringBuffer buf, StringBuffer content) {
        int i = 0;
        while (i < content.length()) {
            this.appendNormalChar(index + i, handle, buf, content.charAt(i));
            ++i;
        }
    }

    public String parse(Reader reader, TagParseHandle handle) throws IOException {
        int ch;
        int index = 0;
        int tag_begin = 0;
        char tag_chr = this.processor.getStartingEscapeChar();
        StringBuffer result = new StringBuffer();
        StringBuffer pending_char = new StringBuffer();
        this.processor.setEscapeState(false);
        while ((ch = reader.read()) != -1) {
            char chr = (char)ch;
            if (!this.processor.isEscapeState()) {
                if (tag_chr == chr) {
                    pending_char.append(chr);
                    this.processor.setEscapeState(true);
                    tag_begin = index;
                } else {
                    this.appendNormalChar(index, handle, result, chr);
                }
            } else {
                if (tag_chr == chr) {
                    this.appendNormalStrings(index, handle, result, pending_char);
                    pending_char.setLength(0);
                    pending_char.append(chr);
                    continue;
                }
                pending_char.append(chr);
                int rst = this.processor.accept(chr);
                if (rst == 2 || rst == 1) {
                    this.processor.setEscapeState(false);
                    this.appendParsedTag(tag_begin, this.processor, result, handle);
                    pending_char.setLength(0);
                } else if (rst == -1) {
                    this.processor.setEscapeState(false);
                    this.appendNormalStrings(index, handle, result, pending_char);
                    pending_char.setLength(0);
                }
            }
            ++index;
        }
        if (this.processor.isEscapeState()) {
            this.appendParsedTag(tag_begin, this.processor, result, handle);
        }
        if (pending_char.length() > 0) {
            this.appendNormalStrings(index - pending_char.length(), handle, result, pending_char);
        }
        return result.toString();
    }

    public void clear() {
        this.processor.clear();
        this.processor = null;
    }

    public String parse(String str, TagParseHandle handle) {
        if (str == null) {
            return null;
        }
        try {
            return this.parse(new StringReader(str), handle);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

