/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.cache.AssociationDesc;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.net.URL;

public class InformationDesc
implements XMLable {
    private String _title;
    private String _vendor;
    private URL _home;
    private String[] _descriptions;
    private IconDesc[] _icons;
    private ShortcutDesc _shortcutHints;
    private AssociationDesc[] _associations;
    private RContentDesc[] _relatedContent;
    private boolean _supportOfflineOperation;
    public static final int DESC_DEFAULT = 0;
    public static final int DESC_SHORT = 1;
    public static final int DESC_ONELINE = 2;
    public static final int DESC_TOOLTIP = 3;
    public static final int NOF_DESC = 4;
    public static final int ICON_SIZE_SMALL = 0;
    public static final int ICON_SIZE_MEDIUM = 1;
    public static final int ICON_SIZE_LARGE = 2;

    public InformationDesc(String string, String string2, URL uRL, String[] stringArray, IconDesc[] iconDescArray, ShortcutDesc shortcutDesc, RContentDesc[] rContentDescArray, AssociationDesc[] associationDescArray, boolean bl) {
        this._title = string;
        this._vendor = string2;
        this._home = uRL;
        if (stringArray == null) {
            stringArray = new String[4];
        }
        this._descriptions = stringArray;
        this._icons = iconDescArray;
        this._shortcutHints = shortcutDesc;
        this._associations = associationDescArray;
        this._relatedContent = rContentDescArray;
        this._supportOfflineOperation = bl;
    }

    public String getTitle() {
        return this._title;
    }

    public String getVendor() {
        return this._vendor;
    }

    public URL getHome() {
        return this._home;
    }

    public boolean supportsOfflineOperation() {
        return this._supportOfflineOperation;
    }

    public IconDesc[] getIcons() {
        return this._icons;
    }

    public ShortcutDesc getShortcut() {
        return this._shortcutHints;
    }

    public AssociationDesc[] getAssociations() {
        return this._associations;
    }

    public RContentDesc[] getRelatedContent() {
        return this._relatedContent;
    }

    public String getDescription(int n) {
        return this._descriptions[n];
    }

    public IconDesc getIconLocation(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n4 = 16;
                n3 = 16;
                break;
            }
            case 1: {
                n4 = 32;
                n3 = 32;
                break;
            }
            case 2: {
                n4 = 64;
                n3 = 64;
            }
        }
        IconDesc iconDesc = null;
        long l = 0L;
        for (int i = 0; i < this._icons.length; ++i) {
            boolean bl;
            IconDesc iconDesc2 = this._icons[i];
            boolean bl2 = bl = n2 == 5 || !iconDesc2.getSuffix().equalsIgnoreCase(".ico");
            if (iconDesc2.getKind() != n2 || !bl) continue;
            if (iconDesc2.getHeight() == n3 && iconDesc2.getWidth() == n4) {
                return iconDesc2;
            }
            if (iconDesc2.getHeight() == 0 && iconDesc2.getWidth() == 0) {
                if (iconDesc != null) continue;
                iconDesc = iconDesc2;
                continue;
            }
            long l2 = Math.abs(iconDesc2.getHeight() * iconDesc2.getWidth() - n3 * n4);
            if (l != 0L && l2 >= l) continue;
            l = l2;
            iconDesc = iconDesc2;
        }
        return iconDesc;
    }

    public XMLNode asXML() {
        int n;
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("information", xMLAttributeBuilder.getAttributeList());
        xMLNodeBuilder.add("title", this._title);
        xMLNodeBuilder.add("vendor", this._vendor);
        xMLNodeBuilder.add(new XMLNode("homepage", new XMLAttribute("href", this._home != null ? this._home.toString() : null), null, null));
        xMLNodeBuilder.add(this.getDescriptionNode(0, ""));
        xMLNodeBuilder.add(this.getDescriptionNode(1, "short"));
        xMLNodeBuilder.add(this.getDescriptionNode(2, "one-line"));
        xMLNodeBuilder.add(this.getDescriptionNode(3, "tooltip"));
        if (this._icons != null) {
            for (n = 0; n < this._icons.length; ++n) {
                xMLNodeBuilder.add((XMLable)this._icons[n]);
            }
        }
        if (this._shortcutHints != null) {
            xMLNodeBuilder.add((XMLable)this._shortcutHints);
        }
        if (this._associations != null) {
            for (n = 0; n < this._associations.length; ++n) {
                xMLNodeBuilder.add((XMLable)this._associations[n]);
            }
        }
        if (this._relatedContent != null) {
            for (n = 0; n < this._relatedContent.length; ++n) {
                xMLNodeBuilder.add((XMLable)this._relatedContent[n]);
            }
        }
        if (this._supportOfflineOperation) {
            xMLNodeBuilder.add(new XMLNode("offline-allowed", null));
        }
        return xMLNodeBuilder.getNode();
    }

    private XMLNode getDescriptionNode(int n, String string) {
        String string2 = this._descriptions[n];
        if (string2 == null) {
            return null;
        }
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("kind", string);
        return new XMLNode("description", xMLAttributeBuilder.getAttributeList(), new XMLNode(string2), null);
    }
}

