/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionSynchronizationRegistryImpl;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class Jotm {
    Current current = null;
    TransactionRecovery transactionrecovery = null;
    TransactionSynchronizationRegistryImpl transactionsynchronizationregistry = null;
    private static final String TMFACTORY_NAME = "TMFactory";
    private TransactionFactory tf = null;
    private boolean local;
    private boolean bound;
    private boolean boundFailed = false;
    public static final Log log = LogFactory.getLog("org.objectweb.jotm");

    public Jotm(boolean local, boolean bound) throws NamingException {
        InitialContext ictx;
        this.local = local;
        this.bound = bound;
        log.info("CAROL initialization");
        try {
            ConfigurationRepository.init();
        }
        catch (ConfigurationException e) {
            log.error("CAROL initialization failed", e);
        }
        if (local) {
            log.info("JOTM started with a local transaction factory");
            try {
                this.tf = new TransactionFactoryImpl();
            }
            catch (RemoteException e) {
                log.error("Instanciation of TransactionFactory failed", e);
            }
            if (bound) {
                try {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
                    ictx = new InitialContext(env);
                    ictx.rebind(TMFACTORY_NAME, (Object)this.tf);
                    log.info("TransactionFactory bound with name TMFactory");
                }
                catch (NamingException e) {
                    log.error("TransactionFactory rebind failed", e);
                    this.boundFailed = true;
                    throw e;
                }
            }
        } else {
            log.info("JOTM started with a remote transaction factory");
            try {
                ictx = new InitialContext();
                this.tf = (TransactionFactory)ictx.lookup(TMFACTORY_NAME);
            }
            catch (NamingException e) {
                log.error("TransactionFactory lookup failed", e);
                throw e;
            }
        }
        try {
            this.current = new Current(this.tf);
            this.transactionsynchronizationregistry = TransactionSynchronizationRegistryImpl.getInstance();
        }
        catch (Exception e) {
            log.error("cannot init Current", e);
        }
    }

    public TransactionManager getTransactionManager() {
        return Current.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        return Current.getUserTransaction();
    }

    public TransactionSynchronizationRegistryImpl getTransactionSynchronizationRegistry() {
        if (log.isDebugEnabled()) {
            log.debug("TransactionSynchronizationRegistry=" + this.transactionsynchronizationregistry);
        }
        return this.transactionsynchronizationregistry;
    }

    public void stop() {
        log.info("stop JOTM");
        try {
            this.current.forget();
        }
        catch (Exception e) {
            log.warn("cannot stop Current", e);
        }
        try {
            if (this.transactionrecovery != null) {
                this.transactionrecovery.forget();
            }
        }
        catch (Exception e) {
            log.warn("cannot stop Recovery", e);
        }
        if (this.local) {
            if (this.bound && !this.boundFailed) {
                try {
                    InitialContext ictx = new InitialContext();
                    ictx.unbind(TMFACTORY_NAME);
                    if (log.isDebugEnabled()) {
                        log.debug("TransactionFactory unbound");
                    }
                }
                catch (Exception e) {
                    log.warn("Cannot unbound the TransactionFactory", e);
                }
            }
            if (this.tf != null) {
                try {
                    PortableRemoteObject.unexportObject((Remote)this.tf);
                    if (log.isDebugEnabled()) {
                        log.debug("TransactionFactory unexported");
                    }
                }
                catch (NoSuchObjectException e) {
                    log.warn("Cannot unexport the TransactionFactory", e);
                }
            }
        }
        this.tf = null;
    }
}

