/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.libs;

import aurora.ide.libs.AuroraResourcesPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class AuroraImagesUtils {
    private static final ImageRegistry PLUGIN_REGISTRY = AuroraResourcesPlugin.getDefault().getImageRegistry();
    public static final IPath ICONS_PATH = new Path("$nl$/icons/");
    private static Map<String, String> keyPathMap = new HashMap<String, String>(){
        {
            this.put("toolbar_bg", "toolbar_bg.gif");
            this.put("itembar", "itembar.gif");
            this.put("btn", "btn.gif");
            this.put("grid_bg", "grid_bg.gif");
            this.put("navigation", "navigation.gif");
            this.put("toolbar_sep", "toolbar_sep.gif");
            this.put("nav1", "nav1.png");
            this.put("nav2", "nav2.png");
            this.put("label", "label.png");
        }
    };

    public static Image getImage(String key) {
        Image image = PLUGIN_REGISTRY.get(key);
        if (image == null) {
            IPath append = ICONS_PATH.append(AuroraImagesUtils.getPath(key));
            ImageDescriptor imageDescriptor = AuroraResourcesPlugin.getImageDescriptor(append.toString());
            PLUGIN_REGISTRY.put(key, imageDescriptor);
            image = PLUGIN_REGISTRY.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor image = PLUGIN_REGISTRY.getDescriptor(key);
        if (image == null) {
            IPath append = ICONS_PATH.append(AuroraImagesUtils.getPath(key));
            ImageDescriptor imageDescriptor = AuroraResourcesPlugin.getImageDescriptor(append.toString());
            PLUGIN_REGISTRY.put(key, imageDescriptor);
            image = PLUGIN_REGISTRY.getDescriptor(key);
        }
        return image;
    }

    private static String getPath(String key) {
        String path = keyPathMap.get(key);
        return path == null ? key : path;
    }

    public static byte[] toBytes(String string) {
        String[] split = string.split(", ");
        byte[] _byteArray = new byte[split.length];
        int i = 0;
        while (i < split.length) {
            String s = split[i];
            _byteArray[i] = Byte.valueOf(s);
            ++i;
        }
        return _byteArray;
    }

    public static byte[] toBytes(ImageData imageData, int format) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[1];
        imageLoader.data[0] = imageData;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)outputStream, format);
        byte[] byteArray = outputStream.toByteArray();
        return byteArray;
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static ImageData toImageData(byte[] iconByteData) {
        ByteArrayInputStream is = new ByteArrayInputStream(iconByteData);
        ImageLoader imageLoader = new ImageLoader();
        ImageData idd = imageLoader.load((InputStream)is)[0];
        return idd;
    }

    public static RGB toRGB(String color) {
        String[] split = color.split(",");
        return new RGB(Integer.valueOf(split[0]).intValue(), Integer.valueOf(split[1]).intValue(), Integer.valueOf(split[2]).intValue());
    }

    public static String toString(RGB color) {
        return String.valueOf(color.red) + "," + color.green + "," + color.blue;
    }

    public static ImageData loadImageData(Path path) throws FileNotFoundException {
        ImageLoader loader = new ImageLoader();
        ImageData[] load = loader.load((InputStream)new FileInputStream(path.toFile()));
        ImageData imageData = load[0];
        return imageData;
    }

    public static String queryFile(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setText("Open File");
        dialog.setFilterExtensions(new String[]{"*.png", "*.gif", "*.jpg", "*.jpeg", "*.bmp", "*.tiff"});
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return path;
        }
        return null;
    }

    public static int getIconType(String ext) {
        if ("png".equalsIgnoreCase(ext)) {
            return 5;
        }
        if ("gif".equalsIgnoreCase(ext)) {
            return 2;
        }
        if ("jpg".equalsIgnoreCase(ext)) {
            return 4;
        }
        if ("jpeg".equalsIgnoreCase(ext)) {
            return 4;
        }
        if ("bmp".equalsIgnoreCase(ext)) {
            return 0;
        }
        if ("tiff".equalsIgnoreCase(ext)) {
            return 6;
        }
        return -1;
    }
}

