/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity.gen;

import aurora.plugin.entity.EntityGeneratorConfig;
import aurora.plugin.entity.gen.BaseBmGenerator;
import aurora.plugin.entity.gen.DuplicateException;
import aurora.plugin.entity.model.BMModel;
import aurora.plugin.entity.model.Record;
import uncertain.composite.CompositeMap;

public class ExtendBmGenerator
extends BaseBmGenerator {
    public ExtendBmGenerator(BMModel model) {
        super(model);
    }

    @Override
    protected String getBaseTable() {
        return null;
    }

    @Override
    protected String getExtend() {
        return String.valueOf(EntityGeneratorConfig.getInstance().getEntityPath()) + "." + this.getModel().getName();
    }

    @Override
    protected String getExtendMode() {
        return "reference";
    }

    @Override
    protected void setUpModelMap(CompositeMap map) throws DuplicateException {
        map.addChild(this.genFieldsMap());
    }

    private CompositeMap genFieldsMap() {
        CompositeMap fieldsMap = this.newCompositeMap("fields");
        Record[] recordArray = this.getModel().getRecords(true);
        int n = recordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Record r = recordArray[n2];
            if (r.isForLov()) {
                CompositeMap m = this.newCompositeMap("field");
                m.put((Object)"name", (Object)r.getName());
                if (r.isForQuery()) {
                    m.put((Object)"forQuery", (Object)true);
                }
                if (r.isForDisplay()) {
                    m.put((Object)"forDisplay", (Object)true);
                }
                if (r.get("displayWidth") != null) {
                    m.put((Object)"displayWidth", r.get("displayWidth"));
                }
                if (r.get("queryWidth") != null) {
                    m.put((Object)"queryWidth", r.get("queryWidth"));
                }
                fieldsMap.addChild(m);
            }
            ++n2;
        }
        return fieldsMap;
    }
}

