/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ldap;

import aurora.application.util.LanguageUtil;
import aurora.plugin.ldap.LdapConfig;
import aurora.plugin.ldap.LdapServerInstance;
import aurora.service.ServiceContext;
import aurora.service.validation.ErrorMessage;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class LdapAuthentication
extends AbstractEntry {
    LdapConfig ldapMap;
    List<LdapServerInstance> ldapServerList = null;
    String serverName;
    String username;
    String password;
    String errorMessage;
    IObjectRegistry mObjectRegistry;

    public LdapAuthentication(LdapConfig ldapMap, IObjectRegistry reg) {
        this.ldapMap = ldapMap;
        this.mObjectRegistry = reg;
        this.ldapServerList = this.ldapMap.getInstanceList();
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.validateParameter(context);
        Iterator<LdapServerInstance> iterator = this.ldapServerList.iterator();
        Throwable exception = null;
        while (iterator.hasNext()) {
            LdapServerInstance ldapServer = iterator.next();
            if (!this.serverName.equals(ldapServer.getName())) continue;
            exception = null;
            String user = this.getUsername().indexOf(ldapServer.getDomain()) > 0 ? this.getUsername() : String.valueOf(this.getUsername()) + ldapServer.getDomain();
            String url = "ldap://" + ldapServer.getHost() + ":" + ldapServer.getPort();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", ldapServer.getInitialContextFactory());
            env.put("java.naming.security.authentication", ldapServer.getSecurityAuthentication());
            env.put("java.naming.security.principal", user);
            env.put("java.naming.security.credentials", this.getPassword());
            if (ldapServer.getSSLEnabled().booleanValue()) {
                url = "ldaps://" + ldapServer.getHost() + ":" + ldapServer.getPort();
                env.remove("java.naming.security.authentication");
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", "aurora.plugin.ldap.SSLSocketFactoryWrap");
            }
            env.put("java.naming.provider.url", url);
            InitialLdapContext ctx = null;
            try {
                ctx = new InitialLdapContext(env, null);
                return;
            }
            catch (NamingException e) {
                exception = e;
            }
            finally {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                }
                catch (NamingException namingException) {}
            }
        }
        if (exception != null) {
            if (exception.getMessage().startsWith("[LDAP: error code 49")) {
                String error_message = this.getErrorMessage();
                error_message = LanguageUtil.getTranslatedMessage((IObjectRegistry)this.mObjectRegistry, (String)error_message, (CompositeMap)context);
                ErrorMessage msg = new ErrorMessage(null, error_message, null);
                ServiceContext sc = ServiceContext.createServiceContext((CompositeMap)context);
                sc.setError(msg.getObjectContext());
                sc.put((Object)"success", (Object)false);
                runner.getCaller().locateTo("CreateResponse");
                runner.stop();
            } else {
                throw exception;
            }
        }
    }

    void validateParameter(CompositeMap context) {
        this.username = TextParser.parse((String)this.username, (CompositeMap)context);
        if (this.username == null) {
            throw new IllegalStateException("parameter \"username\" is null");
        }
        this.password = TextParser.parse((String)this.password, (CompositeMap)context);
        if (this.password == null) {
            throw new IllegalStateException("parameter \"password\" is null");
        }
        this.serverName = TextParser.parse((String)this.serverName, (CompositeMap)context);
        if (this.serverName == null) {
            throw new IllegalStateException("parameter \"serverName\" is null");
        }
        this.errorMessage = TextParser.parse((String)this.errorMessage, (CompositeMap)context);
        if (this.errorMessage == null) {
            throw new IllegalStateException("parameter \"errorMessage\" is null");
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

