/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen;

import aurora.plugin.source.gen.BuilderSession;
import aurora.plugin.source.gen.IDGenerator;
import aurora.plugin.source.gen.ISourceTemplateProvider;
import aurora.plugin.source.gen.ModelMapParser;
import aurora.plugin.source.gen.SourceTemplateProvider;
import aurora.plugin.source.gen.builders.ISourceBuilder;
import aurora.plugin.source.gen.test.Test;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;
import uncertain.pkg.IPackageManager;
import uncertain.pkg.PackageManager;

public class SourceGenManager {
    private IObjectRegistry registry;
    private Map<String, String> builders;
    private ISourceTemplateProvider sourceTemplateProvider;
    private IDGenerator idg = new IDGenerator();

    public SourceGenManager() {
    }

    public SourceGenManager(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void buildTestScreen() {
        try {
            CompositeMap buildScreen = this.buildScreen(Test.loadCompositeMap());
            System.out.println(buildScreen.toXML());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public CompositeMap buildScreen(CompositeMap modelMap) throws IOException, SAXException {
        this.loadBuilders();
        BuilderSession session = new BuilderSession(this);
        CompositeMap screenModel = this.createScreenModel(modelMap);
        session.setModel(screenModel);
        String buildComponent = this.buildComponent(session, screenModel);
        CompositeLoader parser = new CompositeLoader();
        CompositeMap loadFromString = parser.loadFromString(buildComponent, "utf-8");
        return loadFromString;
    }

    public CompositeMap buildScreen(CompositeMap modelMap, BuilderSession session) throws IOException, SAXException {
        this.loadBuilders();
        CompositeMap screenModel = this.createScreenModel(modelMap);
        session.setModel(screenModel);
        String buildComponent = this.buildComponent(session, screenModel);
        CompositeLoader parser = new CompositeLoader();
        CompositeMap loadFromString = parser.loadFromString(buildComponent, "utf-8");
        return loadFromString;
    }

    public String buildComponent(BuilderSession session, CompositeMap modelMap) {
        this.buildContext(session, modelMap);
        return this.bindTemplate(session);
    }

    public String bindTemplate(BuilderSession session) {
        ISourceTemplateProvider tmplConfig = this.getTemplateProvider();
        return tmplConfig.bindTemplate(session);
    }

    public ISourceTemplateProvider getTemplateProvider() {
        return this.sourceTemplateProvider;
    }

    private void buildContext(BuilderSession session, CompositeMap modelMap) {
        ISourceBuilder builder = this.getBuilder(modelMap);
        if (builder == null) {
            builder = this.getDefaultBuilder();
        }
        session.setCurrentModel(modelMap);
        builder.buildContext(session);
    }

    private ISourceBuilder getDefaultBuilder() {
        return this.createNewInstance("aurora.plugin.source.gen.builders.DefaultSourceBuilder");
    }

    private ISourceBuilder getBuilder(CompositeMap modelMap) {
        String component_type = modelMap.getString((Object)"component_type", "");
        String b = this.getBuilders().get(component_type.toLowerCase());
        if (b == null || "".equals(b)) {
            return null;
        }
        return this.createNewInstance(b);
    }

    public ISourceBuilder createNewInstance(String className) {
        ISourceBuilder newInstance = null;
        try {
            newInstance = (ISourceBuilder)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return newInstance;
    }

    protected void loadBuilders() {
        if (this.getBuilders() != null) {
            return;
        }
        this.setBuilders(new HashMap<String, String>());
        UncertainEngine engine = (UncertainEngine)this.registry.getInstanceOfType(UncertainEngine.class);
        File configDirectory = engine.getConfigDirectory();
        File f = new File(configDirectory, "aurora.plugin.source.gen");
        File config = new File(f, "config");
        File component_file = new File(config, "components.xml");
        CompositeLoader loader = this.getCompositeLoader();
        try {
            CompositeMap components = loader.loadByFullFilePath(component_file.getPath());
            components.iterate(new IterationHandle(){

                public int process(CompositeMap map) {
                    String component_type = map.getString((Object)"component_type", "");
                    String builder = map.getString((Object)"builder", "");
                    if (!"".equals(component_type)) {
                        SourceGenManager.this.getBuilders().put(component_type.toLowerCase(), builder);
                    }
                    return 0;
                }
            }, false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private CompositeLoader getCompositeLoader() {
        return this.getPackageManager().getCompositeLoader();
    }

    private PackageManager getPackageManager() {
        return (PackageManager)this.registry.getInstanceOfType(IPackageManager.class);
    }

    public void buildBM(CompositeMap modelMap) {
    }

    public void setTemplateProvider(ISourceTemplateProvider sourceTemplateProvider) {
        this.sourceTemplateProvider = sourceTemplateProvider;
        if (sourceTemplateProvider instanceof SourceTemplateProvider) {
            ((SourceTemplateProvider)sourceTemplateProvider).setSourceGenManager(this);
        }
    }

    private CompositeMap createScreenModel(CompositeMap bodyMap) {
        CompositeMap screen = new CompositeMap("screen");
        screen.setNameSpace("a", "http://www.aurora-framework.org/application");
        screen.put((Object)"component_type", (Object)"screen");
        screen.put((Object)"markid", (Object)"screen3310");
        CompositeMap view = screen.createChild("a", "http://www.aurora-framework.org/application", "view");
        view.put((Object)"component_type", (Object)"view");
        view.put((Object)"markid", (Object)"view3310");
        view.addChild(bodyMap);
        screen.put((Object)"template_type", (Object)bodyMap.getString((Object)"diagram_bind_template", ""));
        return screen;
    }

    public Map<String, String> getBuilders() {
        return this.builders;
    }

    public void setBuilders(Map<String, String> builders) {
        this.builders = builders;
    }

    public ModelMapParser createModelMapParser(CompositeMap model) {
        ModelMapParser mmp = new ModelMapParser(this.registry, model);
        return mmp;
    }

    public IDGenerator getIDGenerator() {
        return this.idg;
    }

    public void setIdg(IDGenerator idg) {
        this.idg = idg;
    }
}

