/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.JavascriptRhino;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.IDialogEditableObject;

public class FootRenderer
extends AuroraComponent
implements IDialogEditableObject {
    public static final String DISABLE = "disable";
    public static final String PLAIN_TEXT = "text";
    public static final String COLUMNS_SUM = "sum";
    public static final String USER = "user";
    public static final String[] FOOTRENDERER_TYPES = new String[]{"disable", "text", "sum", "user"};
    public static String[] function_models = new String[]{"", "function footRenderer(datas,name) {\n\treturn 'text';\n}", "function footRenderer(datas,name) {\n\tvar sum = 0;\n\tfor (var i = 0;i < datas.length;i++) {\n\t\tvar d = datas[i].get(name);\n\t\tvar n = parseFloat(d);\n\t\tif (!isNaN(n)) {\n\t\t\tsum += n;\n\t\t}\n\t}\n\treturn Aurora.formatNumber(sum, 2);\n}", "function footRenderer(datas,name) {\n\t//TODO\n\treturn someValue;\n}"};
    private GridColumn column;

    public FootRenderer() {
        this.setRendererType(FOOTRENDERER_TYPES[0]);
        this.setFunction(function_models[0]);
        this.setComponentType("footrenderer");
    }

    public void setColumn(GridColumn col) {
        this.column = col;
    }

    public GridColumn getColumn() {
        return this.column;
    }

    public boolean isEnabled() {
        return !DISABLE.equals(this.getRendererType());
    }

    @Override
    public String getDescripition() {
        if (!DISABLE.equals(this.getRendererType())) {
            JavascriptRhino js = new JavascriptRhino(this.getFunction());
            return js.getFirstFunctionName();
        }
        return "footRenderer";
    }

    public String getFunction() {
        return this.getStringPropertyValue("foot_renderer_funcrion");
    }

    @Override
    public Object getContextInfo() {
        return this.column;
    }

    @Override
    public FootRenderer clone() {
        FootRenderer r = new FootRenderer();
        r.setRendererType(this.getRendererType());
        r.setFunction(this.getFunction());
        r.column = this.column;
        return r;
    }

    public void setRendererType(String rendererType) {
        this.setPropertyValue("foot_renderer_type", rendererType);
    }

    public void setFunction(String tmpFunction) {
        this.setPropertyValue("foot_renderer_funcrion", tmpFunction);
    }

    public String getRendererType() {
        return this.getStringPropertyValue("foot_renderer_type");
    }
}

