/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model.asm;

import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.entity.model.DataType;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Combox;
import aurora.plugin.source.gen.screen.model.Dataset;
import aurora.plugin.source.gen.screen.model.Form;
import aurora.plugin.source.gen.screen.model.Input;
import aurora.plugin.source.gen.screen.model.Label;
import aurora.plugin.source.gen.screen.model.NumberField;
import aurora.plugin.source.gen.screen.model.TextArea;
import aurora.plugin.source.gen.screen.model.asm.AbstractModelCreator;
import aurora.plugin.source.gen.screen.model.asm.PageGenerator;
import java.util.List;
import uncertain.composite.CompositeMap;

public class FormCreator
extends AbstractModelCreator {
    public FormCreator(DatabaseServiceFactory svcFactory, CompositeMap context) {
        super(svcFactory, context);
    }

    @Override
    public void decorateComponent(AuroraComponent com, CompositeMap formPart) throws Exception {
        Form form = (Form)com;
        try {
            CompositeMap formMap = this.getFormMap(formPart.get((Object)"part_id"));
            form.setTitle(this.getFormTitle(formMap.getString((Object)"entity_name")));
            Dataset ds = form.getDataset();
            ds.setModel(this.getEntityModelPath(formMap.get((Object)"entity_id")));
            form.setCol(formMap.getInt((Object)"col", form.getCol()));
            form.setSize(form.getCol() * 240, form.getSize().y);
            CompositeMap itemsMap = this.getFormItems(formPart.get((Object)"part_id"));
            if (itemsMap != null) {
                List itemList = itemsMap.getChildsNotNull();
                for (CompositeMap m : itemList) {
                    Input input;
                    String editor = FormCreator.getNormalComponentType(m.getString((Object)"editor"));
                    if (this.isViewPage() || "label".equals(editor)) {
                        if (FormCreator.in(editor, "lov", "comboBox")) {
                            Combox cb = new Combox();
                            cb.setName(m.getString((Object)"name"));
                            cb.setPrompt(m.getString((Object)"prompt"));
                            form.addChild(cb);
                            continue;
                        }
                        if (FormCreator.eq(m.getString((Object)"readonly", "false"), "false")) {
                            input = this.createInputExt(m);
                            if (input == null) continue;
                            form.addChild(input);
                            continue;
                        }
                        Label l = this.createLabel(m);
                        form.addChild(l);
                        continue;
                    }
                    input = this.createInputExt(m);
                    if (input == null) continue;
                    form.addChild(input);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Input createInputExt(CompositeMap data) throws Exception {
        Input input = FormCreator.createInput(data.getString((Object)"editor"));
        if (input == null) {
            return null;
        }
        input.setName(data.getString((Object)"name"));
        input.setPrompt(data.getString((Object)"prompt"));
        input.setSize(data.getInt((Object)"width", input.getSize().x), input.getSize().y);
        input.setReadOnly(Boolean.parseBoolean(data.getString((Object)"readonly")));
        input.setRequired(Boolean.parseBoolean(data.getString((Object)"required")));
        if (input instanceof NumberField) {
            DataType dt;
            NumberField nf = (NumberField)input;
            CompositeMap entity_field = this.getEntityField(data.get((Object)"field_id"));
            if (entity_field != null && (dt = DataType.fromString(entity_field.getString((Object)"type"))) == DataType.INTEGER) {
                nf.setAllowDecimals(false);
            }
        }
        if (input instanceof TextArea) {
            TextArea ta = (TextArea)input;
            ta.setSize(ta.getSize().x, data.getInt((Object)"height", ta.getSize().y));
        }
        return input;
    }

    private Label createLabel(CompositeMap data) {
        Label l = new Label();
        l.setName(data.getString((Object)"name"));
        l.setPrompt(data.getString((Object)"prompt"));
        String editor = FormCreator.getNormalComponentType(data.getString((Object)"editor"));
        if ("datePicker".equals(editor)) {
            l.setRenderer("Aurora.formatDate");
        } else if ("dateTimePicker".equals(editor)) {
            l.setRenderer("Aurora.formatDateTime");
        }
        return l;
    }

    private String getFormTitle(String entity_name) {
        return String.valueOf(this.isViewPage() ? "\u67e5\u770b" : "\u7f16\u8f91") + " - " + entity_name;
    }

    @Override
    public AuroraComponent create(CompositeMap formPart) throws Exception {
        Form form = new Form();
        this.decorateComponent(form, formPart);
        return form;
    }

    private CompositeMap getFormMap(Object formId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"custom_form_id", formId);
        return PageGenerator.queryFirst(this.getDatabaseServiceFactory(), this.getContext(), "page.custom_form_for_query", para);
    }

    private CompositeMap getFormItems(Object formId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"custom_form_id", formId);
        return PageGenerator.query(this.getDatabaseServiceFactory(), this.getContext(), "page.custom_form_item_for_query", para);
    }
}

