/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model.asm;

import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.asm.AbstractModelCreator;
import aurora.plugin.source.gen.screen.model.asm.FormCreator;
import aurora.plugin.source.gen.screen.model.asm.GridCreator;
import aurora.plugin.source.gen.screen.model.asm.PageGenerator;
import aurora.plugin.source.gen.screen.model.asm.TemplateDescriptor;
import java.util.List;
import uncertain.composite.CompositeMap;

public class ModelCreator
extends AbstractModelCreator {
    private static String PAGE_ID = "custom_page_id";
    private static String PAGE_TPL = "page_tpl";
    private static String PART_TYPE = "part_type";
    private static String PAGE_PATH = "page_path";

    public ModelCreator(DatabaseServiceFactory svcFactory, CompositeMap context) {
        super(svcFactory, context);
    }

    @Override
    public AuroraComponent create(CompositeMap pageMap) throws Exception {
        CompositeMap pagePartsMap = this.getPagePartsMap(pageMap.get((Object)PAGE_ID));
        String template = pageMap.getString((Object)PAGE_TPL);
        if (template == null) {
            throw new Exception(String.format("page(id=%d) has no template.", pageMap.get((Object)PAGE_ID)));
        }
        List partList = pagePartsMap.getChildsNotNull();
        ScreenBody model = TemplateDescriptor.getModelFromTemplate(template);
        for (CompositeMap m : partList) {
            String type = m.getString((Object)PART_TYPE);
            AuroraComponent ac = this.findComponent(model, type);
            if (ac == null) {
                throw new Exception(String.format("Can not find component in template '%s' with type '%s'.", template, type));
            }
            AbstractModelCreator pCreator = null;
            if ("form".equals(type)) {
                pCreator = new FormCreator(this.getDatabaseServiceFactory(), this.getContext());
            } else if ("grid".equals(type)) {
                pCreator = new GridCreator(this.getDatabaseServiceFactory(), this.getContext());
            }
            if (pCreator == null) continue;
            pCreator.setTemplateType(this.getTemplateType());
            ((AbstractModelCreator)pCreator).decorateComponent(ac, m);
        }
        return model;
    }

    private AuroraComponent findComponent(Container container, String component_type) {
        for (AuroraComponent c : container.getChildren()) {
            AuroraComponent ac;
            if (component_type.equalsIgnoreCase(c.getComponentType())) {
                return c;
            }
            if (!(c instanceof Container) || (ac = this.findComponent((Container)c, component_type)) == null) continue;
            return ac;
        }
        return null;
    }

    @Override
    public void decorateComponent(AuroraComponent com, CompositeMap mainPartMap) throws Exception {
    }

    private CompositeMap getPagePartsMap(Object pageId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)PAGE_ID, pageId);
        return PageGenerator.query(this.getDatabaseServiceFactory(), this.getContext(), this.pgConfig.pagePartModel, para);
    }
}

