/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.tygps;

import aurora.plugin.tygps.GPSProvider;
import aurora.plugin.tygps.Parameter;
import aurora.service.ServiceContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.JSONAdaptor;
import uncertain.composite.TextParser;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class GpsTracker
extends AbstractEntry {
    private GPSProvider provider;
    private String debugger = "false";
    private String path = "gps";
    private String url;
    protected Parameter[] parameters;

    public GpsTracker(IObjectRegistry registry) {
        this.provider = (GPSProvider)registry.getInstanceOfType(GPSProvider.class);
    }

    public void run(ProcedureRunner runner) throws Exception {
        block12: {
            CompositeMap context = runner.getContext();
            ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
            CompositeMap model = service.getModel();
            String url = this.getUrl();
            if (url != null) {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("customerId", this.provider.getCustomerId()));
                params.add(new BasicNameValuePair("userAccount", this.provider.getUserAccount()));
                params.add(new BasicNameValuePair("password", this.provider.getPassword()));
                if (this.parameters != null) {
                    Parameter[] parameterArray = this.parameters;
                    int n = this.parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Parameter parameter = parameterArray[n2];
                        params.add(new BasicNameValuePair(parameter.getName(), TextParser.parse((String)parameter.getValue(), (CompositeMap)model)));
                        ++n2;
                    }
                }
                URI uri = new URI(String.valueOf(url) + "?" + URLEncodedUtils.format(params, (String)"utf-8"));
                HttpGet httpget = new HttpGet(uri);
                try {
                    HttpResponse response;
                    String content;
                    if ("true".equals(this.debugger)) {
                        LoggingContext.getLogger((CompositeMap)context, (String)GpsTracker.class.getCanonicalName()).log(httpget.getURI().toString());
                    }
                    if ((content = EntityUtils.toString((HttpEntity)(response = httpclient.execute((HttpUriRequest)httpget)).getEntity())) == null) break block12;
                    JSONObject jobj = new JSONObject(content);
                    CompositeMap root = JSONAdaptor.toMap((JSONObject)jobj);
                    String success = root.getString((Object)"success");
                    if ("true".equals(success)) {
                        CompositeMap result = root.getChild("result");
                        if (result != null) {
                            ArrayList<CompositeMap> records = new ArrayList<CompositeMap>();
                            List list = result.getChilds();
                            if (list != null) {
                                for (CompositeMap record : list) {
                                    String error = record.getString((Object)"err");
                                    if (error != null) continue;
                                    records.add(record);
                                }
                            }
                            model.addChilds(records);
                        }
                        if ("true".equals(this.debugger)) {
                            LoggingContext.getLogger((CompositeMap)context, (String)GpsTracker.class.getCanonicalName()).log(model.toXML());
                        }
                        break block12;
                    }
                    throw new Exception("GPS Error: " + root.getString((Object)"message"));
                }
                finally {
                    httpclient.getConnectionManager().shutdown();
                }
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDebugger() {
        return this.debugger;
    }

    public void setDebugger(String debugger) {
        this.debugger = debugger;
    }
}

