/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide;

import aurora.ide.StartJob;
import aurora.ide.helpers.DialogUtil;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AuroraPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static final String PLUGIN_ID = "aurora.ide";
    private static AuroraPlugin plugin;
    private IStructuredSelection selection;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindows().length > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        if (window != null) {
            ISelectionService selectionService = window.getSelectionService();
            selectionService.addSelectionListener((ISelectionListener)this);
        }
        StartJob sj = new StartJob();
        sj.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AuroraPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AuroraPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void openFileInEditor(IFile file, String id) {
        IWorkbenchPage wp;
        IWorkbenchWindow iwb = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iwb == null) {
            iwb = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        if ((wp = iwb.getActivePage()) == null) {
            return;
        }
        try {
            wp.openEditor((IEditorInput)new FileEditorInput(file), id);
        }
        catch (PartInitException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IFile getActiveIFile() {
        IWorkbenchPage workbenchPage = AuroraPlugin.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        IEditorPart editorPart = workbenchPage.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        IEditorInput input = editorPart.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile ifile = ((IFileEditorInput)input).getFile();
            return ifile;
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IResource) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public IStructuredSelection getStructuredSelection() {
        return this.selection;
    }

    public static void logToStatusLine(String message, boolean isError) {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WWinActionBars bars = workbenchWindow.getActionBars();
        IStatusLineManager lineManager = bars.getStatusLineManager();
        if (isError) {
            lineManager.setErrorMessage(message);
        } else {
            lineManager.setMessage(message);
        }
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static InputStream openFileStream(String path) throws IOException {
        return FileLocator.openStream((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path(path), (boolean)false);
    }
}

